/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterfortresses.BetterFortressesCommon;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterfortresses.world.ItemFrameChances;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ItemFrameProcessor
extends StructureProcessor {
    public static final ItemFrameProcessor INSTANCE = new ItemFrameProcessor();
    public static final MapCodec<StructureProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.nbt.getString("id").equals("minecraft:item_frame")) {
            String item;
            RandomSource random = structurePlaceSettings.getRandom(globalEntityInfo.blockPos);
            try {
                item = globalEntityInfo.nbt.getCompound("Item").get("id").toString();
            }
            catch (Exception e) {
                BetterFortressesCommon.LOGGER.info("Unable to randomize item frame at {}", (Object)globalEntityInfo.blockPos);
                return globalEntityInfo;
            }
            CompoundTag newNBT = globalEntityInfo.nbt.copy();
            switch (item) {
                case "\"minecraft:stone_sword\"": {
                    String randomItemString = BuiltInRegistries.ITEM.getKey((Object)ItemFrameChances.get().getWeaponItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.getCompound("Item").putString("id", randomItemString);
                    break;
                }
                case "\"minecraft:iron_ingot\"": {
                    String randomItemString = BuiltInRegistries.ITEM.getKey((Object)ItemFrameChances.get().getLootItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.getCompound("Item").putString("id", randomItemString);
                    break;
                }
                case "\"minecraft:cobweb\"": {
                    String randomItemString = BuiltInRegistries.ITEM.getKey((Object)ItemFrameChances.get().getStudyItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    if (randomItemString.equals("minecraft:enchanted_book")) {
                        float f = random.nextFloat();
                        String enchantment = f < 0.2f ? "minecraft:fire_aspect" : (f < 0.4f ? "minecraft:fire_protection" : (f < 0.6f ? "minecraft:flame" : (f < 0.8f ? "minecraft:smite" : "minecraft:binding_curse")));
                        int lvl = enchantment.equals("minecraft:flame") || enchantment.equals("minecraft:binding_curse") ? 1 : (random.nextFloat() < 0.75f ? 1 : 2);
                        CompoundTag componentsTag = newNBT.getCompound("Item").getCompound("components");
                        componentsTag.put("minecraft:stored_enchantments", (Tag)Util.make((Object)new CompoundTag(), enchantmentsTag -> enchantmentsTag.put("levels", (Tag)Util.make((Object)new CompoundTag(), levelsTag -> levelsTag.putInt(enchantment, lvl)))));
                        newNBT.getCompound("Item").put("components", (Tag)componentsTag);
                    }
                    newNBT.getCompound("Item").putString("id", randomItemString);
                    break;
                }
                case "\"minecraft:apple\"": {
                    String randomItemString = BuiltInRegistries.ITEM.getKey((Object)ItemFrameChances.get().getMessHallItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.getCompound("Item").putString("id", randomItemString);
                    break;
                }
                case "\"minecraft:nether_wart\"": {
                    String randomItemString = BuiltInRegistries.ITEM.getKey((Object)ItemFrameChances.get().getAlchemyItem(random)).toString();
                    if (randomItemString.equals("minecraft:air")) {
                        return null;
                    }
                    newNBT.getCompound("Item").putString("id", randomItemString);
                    break;
                }
                case "\"minecraft:glowstone_dust\"": {
                    if (random.nextBoolean()) {
                        newNBT.getCompound("Item").putString("id", "minecraft:blaze_powder");
                        break;
                    }
                    return null;
                }
            }
            newNBT.putInt("TileX", globalEntityInfo.blockPos.getX());
            newNBT.putInt("TileY", globalEntityInfo.blockPos.getY());
            newNBT.putInt("TileZ", globalEntityInfo.blockPos.getZ());
            int minRotation = item.equals("\"minecraft:chiseled_nether_bricks\"") ? 1 : 0;
            int randomRotation = Mth.randomBetweenInclusive((RandomSource)random, (int)minRotation, (int)7);
            newNBT.putByte("ItemRotation", (byte)randomRotation);
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.pos, globalEntityInfo.blockPos, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.ITEM_FRAME_PROCESSOR;
    }
}

