/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.inventory.menu;

import com.aetherteam.aether.data.resources.registries.AetherDataMaps;
import com.aetherteam.aether.inventory.AetherRecipeBookTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.inventory.menu.slot.IncubatorFuelSlot;
import com.aetherteam.aether.inventory.menu.slot.IncubatorItemSlot;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class IncubatorMenu
extends RecipeBookMenu<SingleRecipeInput, IncubationRecipe> {
    public final Container container;
    public final ContainerData data;
    public final Level level;

    public IncubatorMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(7));
    }

    public IncubatorMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)AetherMenuTypes.INCUBATOR.get(), containerId);
        IncubatorMenu.checkContainerSize((Container)container, (int)2);
        IncubatorMenu.checkContainerDataCount((ContainerData)data, (int)7);
        this.container = container;
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new IncubatorItemSlot(this, container, 0, 73, 17, playerInventory.player));
        this.addSlot(new IncubatorFuelSlot(this, container, 1, 73, 53));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(data);
    }

    public void fillCraftSlotsStackedContents(StackedContents contents) {
        Container container = this.container;
        if (container instanceof StackedContentsCompatible) {
            StackedContentsCompatible stackedContentsCompatible = (StackedContentsCompatible)container;
            stackedContentsCompatible.fillStackedContents(contents);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<IncubationRecipe> recipe) {
        return ((IncubationRecipe)recipe.value()).matches(new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    public int getResultSlotIndex() {
        return -1;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 2;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack1 = slot.getItem();
            itemStack = itemStack1.copy();
            if (index != 1 && index != 0 ? (this.canIncubate(itemStack1) ? !this.moveItemStackTo(itemStack1, 0, 1, false) : (this.isFuel(itemStack1) ? !this.moveItemStackTo(itemStack1, 1, 2, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemStack1, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemStack1, 2, 29, false)))) : !this.moveItemStackTo(itemStack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack1);
        }
        return itemStack;
    }

    protected boolean canIncubate(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)AetherRecipeTypes.INCUBATION.get(), (RecipeInput)new SingleRecipeInput(stack), this.level).isPresent();
    }

    public boolean isFuel(ItemStack stack) {
        return stack.getItemHolder().getData(AetherDataMaps.INCUBATOR_FUEL) != null;
    }

    public int getIncubationProgressScaled() {
        return this.data.get(3) != 0 ? this.data.get(2) * 54 / this.data.get(3) : 0;
    }

    public boolean isIncubating() {
        return this.data.get(0) > 0;
    }

    public int getIncubationTimeRemaining() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 1000;
        }
        return this.data.get(0) * 11 / i;
    }

    public BlockPos getIncubatorPos() {
        int x = this.data.get(4);
        int y = this.data.get(5);
        int z = this.data.get(6);
        return new BlockPos(x, y, z);
    }

    public RecipeBookType getRecipeBookType() {
        return AetherRecipeBookTypes.INCUBATOR;
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot != 1;
    }
}

