/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class GlovesLootModifier
extends LootModifier {
    public static final MapCodec<GlovesLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> GlovesLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ItemStack.CODEC.fieldOf("gloves").forGetter(modifier -> modifier.glovesStack)).and((App)BuiltInRegistries.ARMOR_MATERIAL.holderByNameCodec().fieldOf("armor_material").forGetter(modifier -> modifier.armorMaterial)).apply((Applicative)instance, GlovesLootModifier::new));
    public final ItemStack glovesStack;
    public final Holder<ArmorMaterial> armorMaterial;

    public GlovesLootModifier(LootItemCondition[] conditionsIn, ItemStack glovesStack, Holder<ArmorMaterial> armorMaterial) {
        super(conditionsIn);
        this.glovesStack = glovesStack;
        this.armorMaterial = armorMaterial;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> lootStacks, LootContext context) {
        ServerLevel level = context.getLevel();
        RandomSource randomSource = context.getRandom();
        Vec3 vec3 = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (vec3 != null && entity != null) {
            BlockPos pos = BlockPos.containing((Position)vec3);
            BlockEntity blockEntity = context.getLevel().getBlockEntity(pos);
            if (blockEntity instanceof BaseContainerBlockEntity) {
                List<ItemStack> armorItems = lootStacks.stream().filter(itemStack -> {
                    ArmorItem armorItem;
                    Item patt0$temp = itemStack.getItem();
                    return patt0$temp instanceof ArmorItem && (armorItem = (ArmorItem)patt0$temp).getMaterial().equals(this.armorMaterial);
                }).toList();
                for (ItemStack armorStack : armorItems) {
                    if (randomSource.nextInt(4) >= 1) continue;
                    ItemStack gloves = this.glovesStack.copy();
                    int cost = 0;
                    boolean isTreasure = false;
                    for (Object2IntMap.Entry enchantmentInfo : armorStack.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).entrySet()) {
                        Holder enchantment = (Holder)enchantmentInfo.getKey();
                        int enchantmentValue = enchantmentInfo.getIntValue();
                        cost = Math.max(cost, ((Enchantment)enchantment.value()).getMinCost(enchantmentValue));
                        if (!isTreasure) {
                            isTreasure = enchantment.is(EnchantmentTags.TREASURE);
                        }
                        if (!gloves.isPrimaryItemFor(enchantment)) continue;
                        gloves.enchant(enchantment, enchantmentInfo.getIntValue());
                    }
                    if (!armorStack.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).isEmpty() && gloves.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).isEmpty()) {
                        EnchantmentHelper.enchantItem((RandomSource)randomSource, (ItemStack)gloves, (int)cost, (RegistryAccess)level.registryAccess(), Optional.of(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.ON_RANDOM_LOOT)));
                    }
                    if (!armorStack.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).isEmpty() && gloves.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).isEmpty()) continue;
                    lootStacks.replaceAll(stack -> stack.equals(armorStack) ? gloves : stack);
                }
            }
        }
        return lootStacks;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

