/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.placementmodifier;

import com.aetherteam.aether.data.ConfigSerializationUtil;
import com.aetherteam.aether.world.placementmodifier.AetherPlacementModifiers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigFilter
extends PlacementFilter {
    public static final MapCodec<ConfigFilter> CODEC = Codec.STRING.comapFlatMap(ConfigFilter::buildDeserialization, configFilter -> ConfigSerializationUtil.serialize(configFilter.config)).fieldOf("value");
    private final ModConfigSpec.ConfigValue<Boolean> config;

    public ConfigFilter(ModConfigSpec.ConfigValue<Boolean> config) {
        this.config = config;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        return (Boolean)this.config.get();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)AetherPlacementModifiers.CONFIG_FILTER.get();
    }

    private static DataResult<ConfigFilter> buildDeserialization(String configId) {
        ModConfigSpec.ConfigValue<Boolean> configEntry = ConfigSerializationUtil.deserialize(configId);
        if (configEntry instanceof ModConfigSpec.BooleanValue) {
            ModConfigSpec.BooleanValue booleanConfigEntry = (ModConfigSpec.BooleanValue)configEntry;
            return DataResult.success((Object)((Object)new ConfigFilter((ModConfigSpec.ConfigValue<Boolean>)booleanConfigEntry)));
        }
        return DataResult.error(() -> "Config entry " + configId + " does not provide a boolean! Must be boolean (true/false), to be valid for ConfigFilter.");
    }
}

