/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.trunkplacer;

import com.aetherteam.aether.world.trunkplacer.AetherTrunkPlacerTypes;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class GoldenOakTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<GoldenOakTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> GoldenOakTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, GoldenOakTrunkPlacer::new));

    public GoldenOakTrunkPlacer(int height, int heightRandA, int heightRandB) {
        super(height, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)AetherTrunkPlacerTypes.GOLDEN_OAK_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        TrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        for (int i = 0; i < height; ++i) {
            if (i > 4 && random.nextInt(3) > 0 && i < 9) {
                this.branch(level, random, blockSetter, pos.getX(), pos.getY() + i, pos.getZ(), i / 4 - 1, config);
            }
            this.placeLog(level, blockSetter, random, pos.above(i), config);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(height), 0, false));
    }

    public void branch(LevelSimulatedReader level, RandomSource random, BiConsumer<BlockPos, BlockState> blockSetter, int i, int j, int k, int slant, TreeConfiguration config) {
        int directionX = random.nextInt(3) - 1;
        int directionZ = random.nextInt(3) - 1;
        for (int n = 0; n < random.nextInt(2) + 1; ++n) {
            this.placeLog(level, blockSetter, random, new BlockPos(i += directionX, j += slant, k += directionZ), config);
        }
    }
}

