/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betteroceanmonuments.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betteroceanmonuments.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RandomOxidizationProcessor
extends StructureProcessor {
    public static final RandomOxidizationProcessor INSTANCE = new RandomOxidizationProcessor();
    public static final MapCodec<RandomOxidizationProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
        if (blockInfoGlobal.state().getBlock() == Blocks.OXIDIZED_COPPER) {
            BlockState blockState = random.nextFloat() < 0.1f ? Blocks.EXPOSED_COPPER.defaultBlockState() : (random.nextFloat() < 0.3f ? Blocks.WEATHERED_COPPER.defaultBlockState() : Blocks.OXIDIZED_COPPER.defaultBlockState());
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), blockState, blockInfoGlobal.nbt());
        } else if (blockInfoGlobal.state().getBlock() == Blocks.OXIDIZED_CUT_COPPER) {
            BlockState blockState = random.nextFloat() < 0.1f ? Blocks.EXPOSED_CUT_COPPER.defaultBlockState() : (random.nextFloat() < 0.3f ? Blocks.WEATHERED_CUT_COPPER.defaultBlockState() : Blocks.OXIDIZED_CUT_COPPER.defaultBlockState());
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), blockState, blockInfoGlobal.nbt());
        } else if (blockInfoGlobal.state().getBlock() == Blocks.OXIDIZED_CUT_COPPER_STAIRS) {
            BlockState blockState = random.nextFloat() < 0.1f ? Blocks.EXPOSED_CUT_COPPER_STAIRS.withPropertiesOf(blockInfoGlobal.state()) : (random.nextFloat() < 0.3f ? Blocks.WEATHERED_CUT_COPPER_STAIRS.withPropertiesOf(blockInfoGlobal.state()) : Blocks.OXIDIZED_CUT_COPPER_STAIRS.withPropertiesOf(blockInfoGlobal.state()));
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), blockState, blockInfoGlobal.nbt());
        } else if (blockInfoGlobal.state().getBlock() == Blocks.OXIDIZED_CUT_COPPER_SLAB) {
            BlockState blockState = random.nextFloat() < 0.1f ? Blocks.EXPOSED_CUT_COPPER_SLAB.withPropertiesOf(blockInfoGlobal.state()) : (random.nextFloat() < 0.3f ? Blocks.WEATHERED_CUT_COPPER_SLAB.withPropertiesOf(blockInfoGlobal.state()) : Blocks.OXIDIZED_CUT_COPPER_SLAB.withPropertiesOf(blockInfoGlobal.state()));
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), blockState, blockInfoGlobal.nbt());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.RANDOM_OXIDIZATION_PROCESSOR;
    }
}

