/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig;

import com.uraneptus.snowpig.core.data.client.SPItemModelProvider;
import com.uraneptus.snowpig.core.data.client.SPLangProvider;
import com.uraneptus.snowpig.core.data.client.SPSoundDefinitionsProvider;
import com.uraneptus.snowpig.core.data.server.SPRecipeProvider;
import com.uraneptus.snowpig.core.data.server.datapack_registries.SPBiomeModifiers;
import com.uraneptus.snowpig.core.data.server.datapack_registries.SPJukeboxSongProvider;
import com.uraneptus.snowpig.core.data.server.loot.SPLootTableProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPBiomeTagsProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPBlockTagsProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPEntityTagsProvider;
import com.uraneptus.snowpig.core.data.server.tags.SPItemTagsProvider;
import com.uraneptus.snowpig.core.registry.SPAttachmentTypes;
import com.uraneptus.snowpig.core.registry.SPEntityTypes;
import com.uraneptus.snowpig.core.registry.SPItems;
import com.uraneptus.snowpig.core.registry.SPSounds;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="snowpig")
public class SnowPigMod {
    public static final String MOD_ID = "snowpig";
    private static final RegistrySetBuilder SET_BUILDER = new RegistrySetBuilder().add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, SPBiomeModifiers::create).add(Registries.JUKEBOX_SONG, SPJukeboxSongProvider::create);

    public static ResourceLocation modPrefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public SnowPigMod(IEventBus bus) {
        bus.addListener(this::gatherData);
        SPSounds.SOUNDS.register(bus);
        SPItems.ITEMS.register(bus);
        SPEntityTypes.ENTITY_TYPES.register(bus);
        SPAttachmentTypes.ATTACHMENT_TYPES.register(bus);
    }

    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new SPItemModelProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SPSoundDefinitionsProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new SPLangProvider(packOutput));
        SPBlockTagsProvider blockTagProvider = new SPBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        generator.addProvider(includeServer, (DataProvider)blockTagProvider);
        generator.addProvider(includeServer, (DataProvider)new SPItemTagsProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SPEntityTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SPBiomeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new SPLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new SPRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, SET_BUILDER, Set.of(MOD_ID)));
    }
}

