/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig.core.data.server.datapack_registries;

import com.uraneptus.snowpig.SnowPigMod;
import com.uraneptus.snowpig.core.registry.SPEntityTypes;
import com.uraneptus.snowpig.core.tags.SPBiomeTags;
import java.util.function.Supplier;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class SPBiomeModifiers {
    public static void create(BootstrapContext<BiomeModifier> context) {
        SPBiomeModifiers.register(context, "snow_pig", () -> SPBiomeModifiers.addSingleSpawnModifier(context, SPBiomeTags.SNOWPIG_SPAWN_IN, SPEntityTypes.SNOW_PIG.get(), 20, 1, 4));
    }

    private static BiomeModifiers.AddSpawnsBiomeModifier addSingleSpawnModifier(BootstrapContext<BiomeModifier> context, TagKey<Biome> biomeTag, EntityType<?> entity, int weight, int minCount, int maxCount) {
        return BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)context.lookup(Registries.BIOME).getOrThrow(biomeTag), (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData(entity, weight, minCount, maxCount));
    }

    private static void register(BootstrapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)SnowPigMod.modPrefix(name)), (Object)modifier.get());
    }
}

