/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig.core.events;

import com.uraneptus.snowpig.client.entity.render.SnowPigRender;
import com.uraneptus.snowpig.core.ModIntegrations;
import com.uraneptus.snowpig.core.registry.SPEntityTypes;
import com.uraneptus.snowpig.core.registry.SPItems;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="snowpig", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SPClientEvents {
    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(SPEntityTypes.SNOW_PIG.get(), SnowPigRender::new);
    }

    @SubscribeEvent
    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        CreativeModeTab tab = event.getTab();
        if (tabKey == CreativeModeTabs.FOOD_AND_DRINKS) {
            SPClientEvents.addBefore(Items.PORKCHOP, SPItems.FROZEN_PORKCHOP, event);
        }
        if (tabKey == CreativeModeTabs.SPAWN_EGGS) {
            SPClientEvents.addBefore(Items.PIG_SPAWN_EGG, SPItems.SNOW_PIG_EGG, event);
        }
        if (tabKey == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            SPClientEvents.addAfter(Items.MUSIC_DISC_OTHERSIDE, SPItems.MUSIC_DISC_FROSTY_SNIG, event);
        }
        if (!ModIntegrations.IS_FD_LOADED.booleanValue() || !ModIntegrations.IS_AD_LOADED.booleanValue()) {
            // empty if block
        }
    }

    private static void addBefore(Item before, Supplier<? extends ItemLike> inputItem, BuildCreativeModeTabContentsEvent event) {
        event.insertBefore(before.getDefaultInstance(), inputItem.get().asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addAfter(Item after, Supplier<? extends ItemLike> inputItem, BuildCreativeModeTabContentsEvent event) {
        event.insertAfter(after.getDefaultInstance(), inputItem.get().asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

