/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.block;

import java.util.Objects;
import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.data.CachedFlowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CommonFrozenFlowerBlock
extends Block {
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)0, (int)8);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    protected static final VoxelShape[] LAYERS_TO_SHAPE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public CommonFrozenFlowerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(0))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public SoundType getSoundType(BlockState state) {
        if ((Integer)state.getValue((Property)LAYERS) == 0) {
            return SoundType.GRASS;
        }
        return SoundType.SNOW;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        if (type.equals((Object)PathComputationType.LAND)) {
            return (Integer)state.getValue((Property)LAYERS) < 5;
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return LAYERS_TO_SHAPE[(Integer)state.getValue((Property)LAYERS)];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Integer)state.getValue((Property)LAYERS)).equals(0) || ((Integer)state.getValue((Property)LAYERS)).equals(1)) {
            return Shapes.empty();
        }
        return LAYERS_TO_SHAPE[(Integer)state.getValue((Property)LAYERS) - 1];
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter world, BlockPos pos) {
        return LAYERS_TO_SHAPE[(Integer)state.getValue((Property)LAYERS)];
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return LAYERS_TO_SHAPE[(Integer)state.getValue((Property)LAYERS)];
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return (Integer)state.getValue((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos down = pos.below();
        return this.canPlantOnTop(world.getBlockState(down));
    }

    protected boolean canPlantOnTop(BlockState floor) {
        return floor.is(BlockTags.DIRT) || floor.is(Blocks.FARMLAND);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.getBrightness(LightLayer.BLOCK, pos) > 11) {
            CommonFrozenFlowerBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos);
            if ((Integer)state.getValue((Property)LAYERS) != 0) {
                Block cachedFlower = CachedFlowers.getFlower((Level)world, pos);
                world.setBlockAndUpdate(pos, ((Block)Objects.requireNonNullElse(cachedFlower, this)).defaultBlockState());
            }
        }
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        super.destroy(world, pos, state);
        if ((Integer)state.getValue((Property)LAYERS) != 0 && world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            Block cachedFlower = CachedFlowers.getFlower((Level)server, pos);
            world.setBlock(pos, ((Block)Objects.requireNonNullElse(cachedFlower, this)).defaultBlockState(), 3);
        }
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        int layers = (Integer)state.getValue((Property)LAYERS);
        if (layers == 8) {
            return false;
        }
        if (context.getItemInHand().is(Blocks.SNOW.asItem())) {
            if (layers == 0) {
                return true;
            }
            return context.getClickedFace() == Direction.UP;
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (state.is(Blocks.SNOW) || state.is((Block)BuiltInRegistries.BLOCK.get(Winterly.id("frozen_grass")))) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
        }
        return super.getStateForPlacement(ctx);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS});
        builder.add(new Property[]{PERSISTENT});
    }
}

