/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.block;

import java.util.List;
import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.block.entity.GiftBoxBlockEntity;
import neoforge.ru.pinkgoosik.winterly.block.entity.GiftBoxBlockEntityData;
import neoforge.ru.pinkgoosik.winterly.data.GiftBoxData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GiftBoxBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = GiftBoxBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public GiftBoxBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GiftBoxBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GiftBoxBlockEntityData) {
            GiftBoxBlockEntityData entity = (GiftBoxBlockEntityData)blockEntity;
            if (placer != null && stack.getComponents().has(DataComponents.CUSTOM_DATA)) {
                entity.loadAdditional(((CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA)).copyTag(), (HolderLookup.Provider)placer.registryAccess());
            }
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        super.playerWillDestroy(world, pos, state, player);
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof GiftBoxBlockEntityData) {
            GiftBoxBlockEntityData entity = (GiftBoxBlockEntityData)blockEntity;
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (!EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)Winterly.id("gift_box_pickup")))) {
                if (entity.getStacks().isEmpty()) {
                    GiftBoxBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem()));
                } else {
                    entity.getStacks().forEach(st -> GiftBoxBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)st));
                }
            } else {
                ItemStack box = new ItemStack((ItemLike)this);
                if (!entity.getStacks().isEmpty()) {
                    CompoundTag nbt = new CompoundTag();
                    entity.saveAdditional(nbt, (HolderLookup.Provider)player.registryAccess());
                    box.applyComponents(DataComponentMap.builder().set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt)).build());
                }
                GiftBoxBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)box);
            }
        }
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof GiftBoxBlockEntityData) {
            GiftBoxBlockEntityData entity = (GiftBoxBlockEntityData)blockEntity;
            if (!stack.isEmpty() && entity.getStacks().size() < Winterly.config.getGiftBoxCapacity()) {
                BlockItem blockItem;
                Item item = stack.getItem();
                if (item instanceof BlockItem && ((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock || blockItem.getBlock() instanceof GiftBoxBlock)) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                entity.getStacks().add(stack.copy());
                ((BlockEntity)entity).setChanged();
                player.setItemInHand(hand, ItemStack.EMPTY);
                level.playSound(null, pos, SoundEvents.BUNDLE_INSERT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag tag;
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (stack.getComponents().has(DataComponents.CUSTOM_DATA) && (tag = ((CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA)).copyTag()).contains("giftBoxData")) {
            GiftBoxData gift = GiftBoxData.fromNbt(tag.getCompound("giftBoxData"), context.registries());
            gift.stacks.forEach(st -> {
                String name = Language.getInstance().getOrDefault(st.getDescriptionId());
                tooltip.add((Component)Component.nullToEmpty((String)("- " + name + " x" + st.getCount())).toFlatList(Style.EMPTY.withColor(ChatFormatting.GRAY)).get(0));
            });
            return;
        }
        Language lang = Language.getInstance();
        String key = "description.winterly.gift_box.";
        for (int i = 0; i <= 32; ++i) {
            if (lang.has(key + i)) {
                tooltip.add((Component)Component.translatable((String)(key + i)).toFlatList(Style.EMPTY.withColor(ChatFormatting.GRAY)).get(0));
            }
            if (!lang.has(key + (i + 1))) break;
        }
    }
}

