/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.config.WinterlyClothConfig;
import neoforge.ru.pinkgoosik.winterly.config.WinterlyConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WinterlyClientConfig {
    public static Screen buildScreen(Screen parent) {
        ConfigBuilder configBuilder = ConfigBuilder.create().setParentScreen(parent).setTitle(WinterlyClientConfig.text("title"));
        configBuilder.setSavingRunnable(() -> AutoConfig.getConfigHolder(WinterlyClothConfig.class).save());
        ConfigCategory general = configBuilder.getOrCreateCategory(WinterlyClientConfig.text("general"));
        ConfigEntryBuilder entryBuilder = configBuilder.entryBuilder();
        WinterlyClientConfig.setupEntries(general, entryBuilder);
        return configBuilder.build();
    }

    public static void setupEntries(ConfigCategory category, ConfigEntryBuilder builder) {
        WinterlyConfig config = Winterly.config;
        category.addEntry((AbstractConfigListEntry)builder.startIntField(WinterlyClientConfig.text("option.max_gift_box_capacity"), config.maxGiftBoxCapacity).setDefaultValue(3).setSaveConsumer(newValue -> {
            config.maxGiftBoxCapacity = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle(WinterlyClientConfig.text("option.generate_underground_icicles"), config.generateUndergroundIcicles).setDefaultValue(true).setSaveConsumer(newValue -> {
            config.generateUndergroundIcicles = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle(WinterlyClientConfig.text("option.generate_cryomarble"), config.generateCryomarble).setDefaultValue(true).setSaveConsumer(newValue -> {
            config.generateCryomarble = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle(WinterlyClientConfig.text("option.generate_frozen_grass"), config.generateFrozenGrass).setDefaultValue(true).setSaveConsumer(newValue -> {
            config.generateFrozenGrass = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle(WinterlyClientConfig.text("option.generate_frozen_flowers"), config.generateFrozenFlowers).setDefaultValue(true).setSaveConsumer(newValue -> {
            config.generateFrozenFlowers = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle(WinterlyClientConfig.text("option.mob_decorations.enabled"), config.mobDecorations.enabled).setDefaultValue(true).setSaveConsumer(newValue -> {
            config.mobDecorations.enabled = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startBooleanToggle(WinterlyClientConfig.text("option.mob_decorations.only_in_winter"), config.mobDecorations.onlyInWinter).setDefaultValue(true).setSaveConsumer(newValue -> {
            config.mobDecorations.onlyInWinter = newValue;
        }).build());
        category.addEntry((AbstractConfigListEntry)builder.startIntSlider(WinterlyClientConfig.text("option.mob_decorations.chance"), config.mobDecorations.chance, 0, 100).setDefaultValue(15).setSaveConsumer(newValue -> {
            config.mobDecorations.chance = newValue;
        }).build());
    }

    private static Component text(String key) {
        return Component.translatable((String)("config.winterly." + key));
    }
}

