/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.mixin.common;

import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.block.CommonFrozenFlowerBlock;
import neoforge.ru.pinkgoosik.winterly.data.CachedFlowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin {
    @Redirect(method={"tickPrecipitation(Lnet/minecraft/core/BlockPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"))
    boolean canSetSnow(Biome biome, LevelReader view, BlockPos pos) {
        if (!biome.warmEnoughToRain(pos) && pos.getY() >= view.getMinBuildHeight() && pos.getY() < view.getMaxBuildHeight() && view.getBrightness(LightLayer.BLOCK, pos) < 10) {
            BlockState state = view.getBlockState(pos);
            if (view instanceof Level) {
                Level world = (Level)view;
                if (state.is(Blocks.SHORT_GRASS) && Winterly.config.generateFrozenGrass) {
                    world.setBlockAndUpdate(pos, ((Block)BuiltInRegistries.BLOCK.get(Winterly.id("frozen_grass"))).defaultBlockState());
                    return false;
                }
                if (state.getBlock() instanceof FlowerBlock && Winterly.config.generateFrozenFlowers) {
                    world.setBlockAndUpdate(pos, (BlockState)((Block)BuiltInRegistries.BLOCK.get(Winterly.id("frozen_flower"))).defaultBlockState().setValue((Property)CommonFrozenFlowerBlock.LAYERS, (Comparable)Integer.valueOf(1)));
                    CachedFlowers.cacheFlower((Level)view, pos, state.getBlock());
                    return false;
                }
            }
        }
        return biome.shouldSnow(view, pos);
    }
}

