/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.neoforge.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.Optional;
import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.client.model.WinterlyModels;
import neoforge.ru.pinkgoosik.winterly.item.CommonSantaHatItem;
import neoforge.ru.pinkgoosik.winterly.item.CommonScarfItem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class WinterlyCuriosIntegration {
    public static void registerCurio(Item item) {
        CuriosApi.registerCurio((Item)item, (ICurioItem)new ICurioItem(){});
    }

    public static boolean hasVisibleHat(Player player) {
        Optional curiosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosItemHandler.isPresent()) {
            for (Map.Entry entry : ((ICuriosItemHandler)curiosItemHandler.get()).getCurios().entrySet()) {
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                IDynamicStackHandler cosmeticStacksHandler = ((ICurioStacksHandler)entry.getValue()).getCosmeticStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    boolean renderable;
                    ItemStack stack = cosmeticStacksHandler.getStackInSlot(i);
                    NonNullList renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                    boolean bl = renderable = renderStates.size() > i && (Boolean)renderStates.get(i) != false;
                    if (stack.isEmpty() && renderable) {
                        stack = stackHandler.getStackInSlot(i);
                    }
                    if (stack.isEmpty() || !(stack.getItem() instanceof CommonSantaHatItem)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void registerScarfRenderer(final CommonScarfItem scarf) {
        CuriosRendererRegistry.register((Item)scarf, () -> new ICurioRenderer(){

            public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrices, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                EntityModel entityModel = renderLayerParent.getModel();
                if (entityModel instanceof HumanoidModel) {
                    HumanoidModel humanoid = (HumanoidModel)entityModel;
                    WinterlyModels.SCARF_MODEL.scarf.copyFrom(humanoid.body);
                    VertexConsumer vertexConsumer = renderTypeBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)Winterly.id("textures/entity/" + scarf.color + "_scarf.png")));
                    WinterlyModels.SCARF_MODEL.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                }
            }
        });
    }

    public static void registerSantaHatRenderer(final CommonSantaHatItem hat) {
        CuriosRendererRegistry.register((Item)hat, () -> new ICurioRenderer(){

            public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrices, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                EntityModel entityModel = renderLayerParent.getModel();
                if (entityModel instanceof HumanoidModel) {
                    HumanoidModel humanoid = (HumanoidModel)entityModel;
                    WinterlyModels.SANTA_HAT_MODEL.hat.copyFrom(humanoid.head);
                    VertexConsumer vertexConsumer = renderTypeBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)Winterly.id("textures/entity/" + hat.color + "_santa_hat.png")));
                    WinterlyModels.SANTA_HAT_MODEL.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                }
            }
        });
    }
}

