/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.neoforge.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;

public class ChunkData {
    public Map<BlockPos, Block> cachedFlowers = new LinkedHashMap<BlockPos, Block>();

    public static class ChunkDataIAttachmentSerializer
    implements IAttachmentSerializer<Tag, ChunkData> {
        public ChunkData read(IAttachmentHolder holder, Tag tag, HolderLookup.Provider lookup) {
            ChunkData data = new ChunkData();
            CompoundTag cachedFlowersNbt = ((CompoundTag)tag).getCompound("cachedFlowers");
            if (!cachedFlowersNbt.isEmpty()) {
                int size = cachedFlowersNbt.getInt("size");
                for (int i = 0; i < size; ++i) {
                    CompoundTag entry = cachedFlowersNbt.getCompound(String.valueOf(i));
                    BlockPos pos = new BlockPos(entry.getInt("x"), entry.getInt("y"), entry.getInt("z"));
                    Optional block = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)entry.getString("block")));
                    block.ifPresent(bl -> data.cachedFlowers.put(pos, (Block)bl));
                }
            }
            return data;
        }

        public Tag write(ChunkData data, HolderLookup.Provider lookup) {
            CompoundTag cachedFlowersNbt = new CompoundTag();
            cachedFlowersNbt.putInt("size", data.cachedFlowers.size());
            int index = -1;
            for (Map.Entry<BlockPos, Block> entry : data.cachedFlowers.entrySet()) {
                ++index;
                CompoundTag entryNbt = new CompoundTag();
                entryNbt.putInt("x", entry.getKey().getX());
                entryNbt.putInt("y", entry.getKey().getY());
                entryNbt.putInt("z", entry.getKey().getZ());
                entryNbt.putString("block", BuiltInRegistries.BLOCK.getKey((Object)entry.getValue()).toString());
                cachedFlowersNbt.put(String.valueOf(index), (Tag)entryNbt);
            }
            CompoundTag nbt = new CompoundTag();
            nbt.put("cachedFlowers", (Tag)cachedFlowersNbt);
            return nbt;
        }
    }
}

