/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.worldgen;

import neoforge.ru.pinkgoosik.winterly.Winterly;
import neoforge.ru.pinkgoosik.winterly.block.IcicleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CryomarbleFeature
extends Feature<NoneFeatureConfiguration> {
    public CryomarbleFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (!Winterly.config.generateCryomarble) {
            return false;
        }
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        for (int i = -20; i < 20; ++i) {
            BlockPos newOrigin = new BlockPos(origin.getX(), i, origin.getZ());
            if (!world.getBlockState(newOrigin).isAir()) continue;
            origin = newOrigin;
            break;
        }
        if (context.random().nextInt(16) != 0) {
            return false;
        }
        int spawned = 0;
        for (int x = -3; x < 3; ++x) {
            for (int z = -3; z < 3; ++z) {
                for (int y = -3; y < 3; ++y) {
                    int xPos = origin.getX() + x;
                    int zPos = origin.getZ() + z;
                    int yPos = origin.getY() + y;
                    BlockPos pos = new BlockPos(xPos, yPos, zPos);
                    if (context.random().nextInt(Math.abs(x) + Math.abs(y) + Math.abs(z) + 1) != 0 || !world.isEmptyBlock(pos) || !CryomarbleFeature.isStone((BlockState)world.getBlockState(pos.below()))) continue;
                    if (spawned < 3) {
                        world.setBlock(pos, (BlockState)((Block)BuiltInRegistries.BLOCK.get(Winterly.id("raw_cryomarble_shard"))).defaultBlockState().setValue((Property)IcicleBlock.FACING, (Comparable)Direction.UP), 3);
                        ++spawned;
                        continue;
                    }
                    return true;
                }
            }
        }
        return true;
    }
}

