/*
 * Decompiled with CFR 0.152.
 */
package neoforge.ru.pinkgoosik.winterly.worldgen;

import neoforge.ru.pinkgoosik.winterly.Winterly;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class UndergroundIcicleFeature
extends Feature<NoneFeatureConfiguration> {
    public UndergroundIcicleFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext context) {
        if (!Winterly.config.generateUndergroundIcicles) {
            return false;
        }
        boolean generated = false;
        int randomY = context.random().nextInt(100) - 50;
        for (int x = 0; x < 10; ++x) {
            for (int z = 0; z < 10; ++z) {
                for (int y = 0; y < 10; ++y) {
                    int xPos = context.origin().getX() + x;
                    int zPos = context.origin().getZ() + z;
                    int yPos = randomY + y;
                    BlockPos pos = new BlockPos(xPos, yPos, zPos);
                    WorldGenLevel world = context.level();
                    if (context.random().nextInt(4) != 0 || !world.isEmptyBlock(pos) || !UndergroundIcicleFeature.isStone((BlockState)world.getBlockState(pos.above()))) continue;
                    world.setBlock(pos, ((Block)BuiltInRegistries.BLOCK.get(Winterly.id("icicle"))).defaultBlockState(), 3);
                    generated = true;
                }
            }
        }
        return generated;
    }
}

