/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.supermartijn642.additionallanterns.AdditionalLanternsClient;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.additionallanterns.VanillaLanternEvents;
import com.supermartijn642.additionallanterns.WeatheringLanternBlock;
import com.supermartijn642.additionallanterns.data.LanternBlockModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternBlockStateGenerator;
import com.supermartijn642.additionallanterns.data.LanternItemModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternLanguageGenerator;
import com.supermartijn642.additionallanterns.data.LanternLootTableGenerator;
import com.supermartijn642.additionallanterns.data.LanternRecipeGenerator;
import com.supermartijn642.additionallanterns.data.LanternTagGenerator;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;

@Mod(value="additionallanterns")
public class AdditionalLanterns {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"additionallanterns", AdditionalLanterns::randomLantern).filler(items -> {
        for (LanternMaterial material : LanternMaterial.values()) {
            if (material == LanternMaterial.NORMAL) {
                items.accept(Items.LANTERN.getDefaultInstance());
            } else {
                items.accept(material.getLanternBlock().asItem().getDefaultInstance());
            }
            for (LanternColor color : LanternColor.values()) {
                items.accept(material.getLanternBlock(color).asItem().getDefaultInstance());
            }
            if (!material.hasChains) continue;
            items.accept(material.getChainBlock().asItem().getDefaultInstance());
        }
    });
    public static final Logger LOGGER = CommonUtils.getLogger((String)"additionallanterns");
    private static final Random RANDOM = new Random();

    private static ItemStack randomLantern() {
        LanternMaterial material = LanternMaterial.values()[RANDOM.nextInt(LanternMaterial.values().length)];
        int colorIndex = RANDOM.nextInt(LanternColor.values().length + 1);
        LanternColor color = colorIndex < LanternColor.values().length ? LanternColor.values()[colorIndex] : null;
        Item item = material == LanternMaterial.NORMAL && color == null ? Items.LANTERN : material.getLanternBlock(color).asItem();
        return item.getDefaultInstance();
    }

    public AdditionalLanterns(IEventBus eventBus) {
        VanillaLanternEvents.registerEventHandlers();
        eventBus.addListener(AdditionalLanterns::init);
        AdditionalLanterns.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            AdditionalLanternsClient.register();
        }
        AdditionalLanterns.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"additionallanterns");
        for (LanternMaterial material : LanternMaterial.values()) {
            handler.registerBlockCallback(material::registerBlocks);
            handler.registerItemCallback(material::registerItems);
        }
        handler.registerBlockCallback(helper -> {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            builder.put((Object)LanternMaterial.COPPER.getLanternBlock(), (Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock());
            builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(), (Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock());
            builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(), (Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock());
            builder.put((Object)LanternMaterial.COPPER.getChainBlock(), (Object)LanternMaterial.EXPOSED_COPPER.getChainBlock());
            builder.put((Object)LanternMaterial.EXPOSED_COPPER.getChainBlock(), (Object)LanternMaterial.WEATHERED_COPPER.getChainBlock());
            builder.put((Object)LanternMaterial.WEATHERED_COPPER.getChainBlock(), (Object)LanternMaterial.OXIDIZED_COPPER.getChainBlock());
            for (LanternColor color : LanternColor.values()) {
                builder.put((Object)LanternMaterial.COPPER.getLanternBlock(color), (Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(color));
                builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(color));
                builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(color), (Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock(color));
            }
            WeatheringLanternBlock.WEATHERING_MAP = builder.build();
        });
    }

    public static void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            try {
                Supplier oldWaxables = HoneycombItem.WAXABLES;
                HoneycombItem.WAXABLES = Suppliers.memoize(() -> AdditionalLanterns.lambda$init$2((Supplier)oldWaxables));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to replace waxing map! Copper lanterns will not be waxable!", (Throwable)exception);
            }
        });
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"additionallanterns");
        handler.addGenerator(LanternBlockModelGenerator::new);
        handler.addGenerator(LanternItemModelGenerator::new);
        handler.addGenerator(LanternBlockStateGenerator::new);
        handler.addGenerator(LanternLanguageGenerator::new);
        handler.addGenerator(LanternLootTableGenerator::new);
        handler.addGenerator(LanternTagGenerator::new);
        handler.addGenerator(LanternRecipeGenerator::new);
    }

    private static /* synthetic */ BiMap lambda$init$2(Supplier oldWaxables) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)LanternMaterial.COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_EXPOSED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.EXPOSED_COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_EXPOSED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_WEATHERED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.WEATHERED_COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_WEATHERED_COPPER.getChainBlock());
        builder.put((Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock(), (Object)LanternMaterial.WAXED_OXIDIZED_COPPER.getLanternBlock());
        builder.put((Object)LanternMaterial.OXIDIZED_COPPER.getChainBlock(), (Object)LanternMaterial.WAXED_OXIDIZED_COPPER.getChainBlock());
        for (LanternColor color : LanternColor.values()) {
            builder.put((Object)LanternMaterial.COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.EXPOSED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_EXPOSED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.WEATHERED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_WEATHERED_COPPER.getLanternBlock(color));
            builder.put((Object)LanternMaterial.OXIDIZED_COPPER.getLanternBlock(color), (Object)LanternMaterial.WAXED_OXIDIZED_COPPER.getLanternBlock(color));
        }
        builder.putAll((Map)oldWaxables.get());
        return builder.build();
    }
}

