/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.ModelGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.resources.ResourceLocation;

public class LanternBlockModelGenerator
extends ModelGenerator {
    public LanternBlockModelGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addModels(material);
        }
    }

    public void addModels(LanternMaterial material) {
        this.addModel(material, null);
        if (material.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                this.addModel(material, color);
            }
        }
        if (material == LanternMaterial.NORMAL || material.hasChains) {
            this.addChainModel(material);
        }
    }

    public void addModel(LanternMaterial material, LanternColor color) {
        this.model(LanternBlockModelGenerator.getModelLocation(material, color, false, false)).parent(LanternBlockModelGenerator.getModelLocation(false)).texture("material", LanternBlockModelGenerator.getMaterialTexture(material)).texture("color", LanternBlockModelGenerator.getColorTexture(color, false));
        this.model(LanternBlockModelGenerator.getModelLocation(material, color, false, true)).parent(LanternBlockModelGenerator.getModelLocation(false)).texture("material", LanternBlockModelGenerator.getMaterialTexture(material)).texture("color", LanternBlockModelGenerator.getColorTexture(color, true));
        this.model(LanternBlockModelGenerator.getModelLocation(material, color, true, false)).parent(LanternBlockModelGenerator.getModelLocation(true)).texture("material", LanternBlockModelGenerator.getMaterialTexture(material)).texture("color", LanternBlockModelGenerator.getColorTexture(color, false));
        this.model(LanternBlockModelGenerator.getModelLocation(material, color, true, true)).parent(LanternBlockModelGenerator.getModelLocation(true)).texture("material", LanternBlockModelGenerator.getMaterialTexture(material)).texture("color", LanternBlockModelGenerator.getColorTexture(color, true));
    }

    public void addChainModel(LanternMaterial material) {
        this.model(LanternBlockModelGenerator.getChainModelLocation(material)).parent(LanternBlockModelGenerator.getChainModelLocation()).texture("chain", LanternBlockModelGenerator.getChainMaterialTexture(material));
    }

    public static String getModelLocation(LanternMaterial material, LanternColor color, boolean hanging, boolean on) {
        return color == null ? (hanging ? (on ? "block/" + material.getSuffix() + "_hanging_lantern" : "block/" + material.getSuffix() + "_hanging_lantern_off") : (on ? "block/" + material.getSuffix() + "_lantern" : "block/" + material.getSuffix() + "_lantern_off")) : (hanging ? (on ? "block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern" : "block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern_off") : (on ? "block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern" : "block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern_off"));
    }

    public static ResourceLocation getModelLocation(boolean hanging) {
        return hanging ? ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)"block/hanging_lantern") : ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)"block/lantern");
    }

    public static ResourceLocation getMaterialTexture(LanternMaterial material) {
        return ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)("block/materials/" + material.getSuffix() + "_lantern"));
    }

    public static ResourceLocation getColorTexture(LanternColor color, boolean on) {
        return color == null ? (on ? ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/lantern") : ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)"block/lantern_off")) : (on ? ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)("block/colors/" + color.getSuffix() + "_lantern")) : ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)("block/colors/" + color.getSuffix() + "_lantern_off")));
    }

    public static String getChainModelLocation(LanternMaterial material) {
        return "block/" + material.getSuffix() + "_chain";
    }

    public static ResourceLocation getChainModelLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)"block/chain");
    }

    public static ResourceLocation getChainMaterialTexture(LanternMaterial material) {
        if (material == LanternMaterial.NORMAL) {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/chain");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"additionallanterns", (String)("block/materials/" + material.getSuffix() + "_chain"));
    }

    public String getName() {
        return this.modName + " Block Model Generator";
    }
}

