/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SRMSnowLayerBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.convert.BlockConverter;
import snownee.snow.mixin.BlockBehaviourAccess;
import snownee.snow.network.SSnowLandEffectPacket;
import snownee.snow.util.CommonProxy;

public final class Hooks {
    private static final MapDecoder<ResourceLocation> BLOCK_ENTITY_ID = ResourceLocation.CODEC.fieldOf("id");

    private Hooks() {
    }

    public static void placeFeatureExtra(Biome biome, WorldGenLevel level, BlockPos pos, BlockPos belowPos) {
        if (!(SnowCommonConfig.replaceWorldFeature && SnowCommonConfig.placeSnowOnBlockNaturally && SnowCommonConfig.canPlaceSnowInBlock())) {
            return;
        }
        if (biome.warmEnoughToRain(pos) || level.getBrightness(LightLayer.BLOCK, pos) >= 10 || !Hooks.canSnowSurvive((LevelReader)level, pos)) {
            return;
        }
        BlockState blockstate = level.getBlockState(pos);
        if (Hooks.convert((LevelAccessor)level, pos, blockstate, 1, 2, true) && (blockstate = level.getBlockState(belowPos)).hasProperty((Property)BlockStateProperties.SNOWY)) {
            level.setBlock(belowPos, (BlockState)blockstate.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Deprecated
    public static boolean canSnowSurvive(BlockState blockState, BlockGetter level, BlockPos pos) {
        try {
            return Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canSnowSurvive(LevelReader level, BlockPos pos) {
        return Blocks.SNOW.defaultBlockState().canSurvive(level, pos);
    }

    public static boolean canContainState(BlockState blockState) {
        return CoreModule.CONVERTERS.of(blockState) != null;
    }

    public static boolean convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers, int flags, boolean canConvert) {
        return Hooks.convert(level, pos, blockState, layers, flags, canConvert, true);
    }

    public static boolean convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers, int flags, boolean canConvert, boolean checkSurvive) {
        BlockState newState = Hooks.getSnowBlockFor(level, pos, blockState, layers, canConvert);
        if (newState == null) {
            return false;
        }
        if (checkSurvive && !newState.canSurvive((LevelReader)level, pos)) {
            return false;
        }
        level.setBlock(pos, newState, flags);
        SRMSnowLayerBlock.setContainedState(level, pos, blockState);
        Hooks.processFancyOverlay(level, pos, ItemStack.EMPTY);
        return true;
    }

    public static void processFancyOverlay(LevelAccessor level, BlockPos pos, ItemStack itemStack) {
        SnowBlockEntity be;
        block5: {
            block4: {
                BlockEntity blockEntity;
                if (itemStack.has(DataComponents.BLOCK_ENTITY_DATA) || !((blockEntity = level.getBlockEntity(pos)) instanceof SnowBlockEntity)) break block4;
                be = (SnowBlockEntity)blockEntity;
                if (!be.options.renderOverlay) break block5;
            }
            return;
        }
        if (SnowCommonConfig.fancySnowOnUpperSlab && level.getBlockState(pos.below()).getBlock() instanceof SlabBlock) {
            be.options.renderOverlay = true;
            be.setChanged();
        }
    }

    @Nullable
    public static BlockState getSnowBlockFor(LevelAccessor level, BlockPos pos, BlockState blockState, int layers, boolean canConvert) {
        if (SnowCommonConfig.restoreOriginalBlocks || blockState.hasBlockEntity() || !blockState.getFluidState().isEmpty() || blockState.is(CoreModule.NOT_CONTAINABLES)) {
            return null;
        }
        if (!(blockState.isAir() || canConvert && SnowCommonConfig.canPlaceSnowInBlock())) {
            return null;
        }
        BlockConverter converter = CoreModule.CONVERTERS.of(blockState);
        if (converter == null) {
            return null;
        }
        if ((blockState = converter.convert(level, pos, blockState, layers)).hasProperty((Property)SnowVariant.OPTIONAL_LAYERS)) {
            blockState = (BlockState)blockState.setValue((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            BlockPos posDown = pos.below();
            BlockState stateDown = level.getBlockState(posDown);
            blockState = blockState.updateShape(Direction.DOWN, stateDown, level, pos, posDown);
        } else if (blockState.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            blockState = (BlockState)blockState.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers));
        }
        return blockState;
    }

    public static <T extends Comparable<T>> boolean hasAllProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : newState.getValues().entrySet()) {
            Property property = (Property)entry.getKey();
            if (property == SnowVariant.OPTIONAL_LAYERS || oldState.hasProperty(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.getValues().entrySet()) {
            Property property = (Property)entry.getKey();
            newState = (BlockState)newState.trySetValue(property, (Comparable)property.getValueClass().cast(entry.getValue()));
        }
        return newState;
    }

    public static boolean placeLayersOn(Level level, BlockPos pos, int layers, boolean fallingEffect, BlockPlaceContext useContext, boolean playSound, boolean canConvert) {
        layers = Mth.clamp((int)layers, (int)1, (int)8);
        BlockState state = level.getBlockState(pos);
        int originLayers = 0;
        if (state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            originLayers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(Mth.clamp((int)(originLayers + layers), (int)1, (int)8))));
        } else if (state.hasProperty((Property)SnowVariant.OPTIONAL_LAYERS)) {
            originLayers = (Integer)state.getValue((Property)SnowVariant.OPTIONAL_LAYERS);
            if (originLayers == 0 && !Hooks.canSnowSurvive((LevelReader)level, pos)) {
                return false;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(Mth.clamp((int)(originLayers + layers), (int)1, (int)8))));
        } else if (state.canSurvive((LevelReader)level, pos) && (canConvert || state.canBeReplaced(useContext))) {
            if (!Hooks.convert((LevelAccessor)level, pos, state, layers, 3, canConvert)) {
                return false;
            }
        } else {
            return false;
        }
        BlockState newState = level.getBlockState(pos);
        Block.pushEntitiesUp((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos);
        if (fallingEffect) {
            new SSnowLandEffectPacket(pos, (byte)originLayers, (byte)layers).sendToAround((ServerLevel)level);
        } else if (playSound) {
            SoundType soundtype = ((BlockBehaviourAccess)Blocks.SNOW).callGetSoundType(Blocks.SNOW.defaultBlockState());
            level.playSound(null, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.above();
            newState = level.getBlockState(pos);
            useContext = BlockPlaceContext.at((BlockPlaceContext)useContext, (BlockPos)pos, (Direction)Direction.UP);
            if (Hooks.canSnowSurvive((LevelReader)level, pos) && newState.canBeReplaced(useContext)) {
                Hooks.placeLayersOn(level, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound, canConvert);
            }
        }
        return true;
    }

    public static boolean canFallThrough(BlockState state, Level level, BlockPos pos) {
        SnowVariant snow;
        Block block = state.getBlock();
        if (block instanceof SnowVariant && (snow = (SnowVariant)block).srm$maxLayers(state, level, pos) == 8 && snow.srm$layers(state, (BlockGetter)level, pos) < 8) {
            return true;
        }
        return FallingBlock.isFree((BlockState)state) && state.getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    public static void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Hooks.randomTick(state, level, pos, random, 0.125f);
    }

    public static void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, float chance) {
        boolean melt;
        if (chance != 1.0f && random.nextFloat() > chance) {
            return;
        }
        Holder biome = level.getBiome(pos);
        SnowVariant snow = (SnowVariant)state.getBlock();
        int layers = snow.srm$layers(state, (BlockGetter)level, pos);
        boolean meltByTemperature = false;
        boolean meltByBrightness = false;
        if (!SnowCommonConfig.snowNeverMelt) {
            if (layers == 8) {
                SnowVariant s;
                BlockPos above = pos.above();
                BlockState upState = level.getBlockState(above);
                Block block = upState.getBlock();
                if (block instanceof SnowVariant && (s = (SnowVariant)block).srm$layers(upState, (BlockGetter)level, above) > 0) {
                    return;
                }
                meltByBrightness = level.getBrightness(LightLayer.BLOCK, above) >= SnowCommonConfig.snowPersistMaxLightLevel;
            } else {
                meltByBrightness = level.getBrightness(LightLayer.BLOCK, pos) > SnowCommonConfig.snowPersistMaxLightLevel;
            }
            meltByTemperature = CommonProxy.shouldMelt((Level)level, pos, (Holder<Biome>)biome, layers);
        }
        boolean bl = melt = meltByTemperature || meltByBrightness;
        if (!melt && SnowCommonConfig.accumulationWinterOnly && !CommonProxy.isWinter((Level)level, pos, (Holder<Biome>)biome)) {
            return;
        }
        boolean accumulate = false;
        if (layers < SnowCommonConfig.snowAccumulationMaxLayers && !meltByBrightness && level.isRaining() && CommonProxy.coldEnoughToSnow((LevelReader)level, pos, (Holder<Biome>)biome) && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() == pos.getY()) {
            accumulate = CommonProxy.snowAccumulationNow((Level)level);
        }
        if (accumulate) {
            if (!level.getBlockState(pos.below()).is(CoreModule.CANNOT_ACCUMULATE_ON)) {
                Hooks.accumulate(level, pos, state, (w, p) -> {
                    if (SnowCommonConfig.snowAccumulationMaxLayers < 9 && w.getBlockState(p.below()).getBlock() instanceof SnowLayerBlock) {
                        return false;
                    }
                    if (SnowCommonConfig.snowSpawnMaxLightLevel < 15 && w.getBrightness(LightLayer.BLOCK, p) > SnowCommonConfig.snowSpawnMaxLightLevel) {
                        return false;
                    }
                    return CommonProxy.coldEnoughToSnow((LevelReader)w, p, (Holder<Biome>)w.getBiome(p));
                }, true);
            }
        } else if (melt) {
            Hooks.accumulate(level, pos, state, (w, p) -> !(w.getBlockState(p.above()).getBlock() instanceof SnowLayerBlock), false);
        }
    }

    private static void accumulate(ServerLevel level, BlockPos centerPos, BlockState centerState, BiPredicate<LevelAccessor, BlockPos> filter, boolean accumulate) {
        if (!SnowCommonConfig.smoothAccumulation) {
            Hooks.accumulateSingle(level, centerPos, centerState, accumulate);
            return;
        }
        SnowVariant centerSnowVariant = (SnowVariant)centerState.getBlock();
        int i = centerSnowVariant.srm$layers(centerState, (BlockGetter)level, centerPos);
        BlockPos.MutableBlockPos pos = centerPos.mutable();
        for (int j = 0; j < 8; ++j) {
            int l;
            int k = j / 2;
            Direction direction = Direction.from2DDataValue((int)k);
            pos.setWithOffset((Vec3i)centerPos, direction);
            if (j % 2 == 1) {
                pos.move(direction);
            }
            if (!level.isLoaded((BlockPos)pos) || !filter.test((LevelAccessor)level, (BlockPos)pos)) continue;
            BlockState state = level.getBlockState((BlockPos)pos);
            BlockPos height = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos);
            if (height.getY() != pos.getY() && (height.getY() != pos.getY() + 1 || !(state.getBlock() instanceof SnowVariant)) || !Hooks.canSnowSurvive((LevelReader)level, (BlockPos)pos)) continue;
            Block block = state.getBlock();
            if (block instanceof SnowVariant) {
                SnowVariant snowVariant = (SnowVariant)block;
                l = snowVariant.srm$layers(state, (BlockGetter)level, (BlockPos)pos);
                if (accumulate) {
                    if (l >= snowVariant.srm$maxLayers(state, (Level)level, (BlockPos)pos) || level.getBlockState((BlockPos)pos.move(Direction.DOWN)).is(CoreModule.CANNOT_ACCUMULATE_ON)) continue;
                    pos.move(Direction.UP);
                }
            } else {
                if (accumulate && !SnowCommonConfig.canPlaceSnowInBlock() && !state.isAir()) continue;
                l = 0;
            }
            if (!(accumulate ? i > l : i < l)) continue;
            Hooks.accumulateSingle(level, (BlockPos)pos, state, accumulate);
            return;
        }
        Hooks.accumulateSingle(level, centerPos, centerState, accumulate);
    }

    private static void accumulateSingle(ServerLevel level, BlockPos pos, BlockState state, boolean accumulate) {
        if (accumulate) {
            Hooks.placeLayersOn((Level)level, pos, 1, false, (BlockPlaceContext)new DirectionalPlaceContext((Level)level, pos, Direction.UP, ItemStack.EMPTY, Direction.DOWN), false, SnowCommonConfig.placeSnowOnBlockNaturally);
        } else {
            SnowVariant snowVariant = (SnowVariant)state.getBlock();
            level.setBlockAndUpdate(pos, snowVariant.srm$decreaseLayer(state, (Level)level, pos, false));
        }
    }

    public static boolean isSnowySetting(BlockState blockState) {
        if (!blockState.is(CoreModule.SNOWY_SETTING)) {
            return false;
        }
        if (blockState.hasProperty((Property)SnowVariant.OPTIONAL_LAYERS)) {
            return (Integer)blockState.getValue((Property)SnowVariant.OPTIONAL_LAYERS) != 0;
        }
        return true;
    }

    public static boolean canBeReplaced(BlockState blockState, BlockPlaceContext context) {
        int i;
        boolean opt = false;
        if (blockState.hasProperty((Property)SnowVariant.OPTIONAL_LAYERS)) {
            i = (Integer)blockState.getValue((Property)SnowVariant.OPTIONAL_LAYERS);
            opt = true;
        } else if (blockState.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            i = (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS);
        } else {
            throw new IllegalStateException("Invalid block state: " + String.valueOf(blockState));
        }
        if (i == 8) {
            return false;
        }
        if (!context.getItemInHand().is(Items.SNOW)) {
            if (!((SnowVariant)blockState.getBlock()).srm$getRaw(blockState, (BlockGetter)context.getLevel(), context.getClickedPos()).isAir()) {
                return false;
            }
            return SnowCommonConfig.snowAlwaysReplaceable || i == 1;
        }
        if (i == 0) {
            return Hooks.canSnowSurvive((LevelReader)context.getLevel(), context.getClickedPos());
        }
        return opt || context.replacingClickedOnBlock() || context.getClickedFace() == Direction.UP;
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext context, @Nullable BlockState originalState) {
        if (SnowCommonConfig.restoreOriginalBlocks) {
            return originalState;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (block == Blocks.SNOW) {
            BlockState stateBelow;
            BlockState state = level.getBlockState(pos);
            if (state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
                int i = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
                return (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
            }
            if (state.hasProperty((Property)SnowVariant.OPTIONAL_LAYERS)) {
                int i = (Integer)state.getValue((Property)SnowVariant.OPTIONAL_LAYERS);
                return (BlockState)state.setValue((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
            }
            if (SnowCommonConfig.fancySnowOnUpperSlab && (stateBelow = level.getBlockState(pos.below())).getBlock() instanceof SlabBlock) {
                return CoreModule.SNOW_BLOCK.defaultBlockState();
            }
        }
        CustomData blockEntityData = (CustomData)context.getItemInHand().get(DataComponents.BLOCK_ENTITY_DATA);
        if (originalState != null && blockEntityData != null) {
            ResourceLocation id = blockEntityData.read(BLOCK_ENTITY_ID).result().orElse(null);
            if (originalState.canSurvive((LevelReader)level, pos) && (CoreModule.TILE.key().equals((Object)id) || CoreModule.TEXTURE_TILE.key().equals((Object)id))) {
                return Hooks.getSnowBlockFor((LevelAccessor)level, pos, (BlockState)originalState.trySetValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 1, true);
            }
        }
        return originalState;
    }

    public static boolean canPlaceAt(Level level, BlockPos pos) {
        BlockState snowBlock = Hooks.getSnowBlockFor((LevelAccessor)level, pos, level.getBlockState(pos), 1, true);
        return snowBlock != null && snowBlock.canSurvive((LevelReader)level, pos);
    }

    public static boolean useSnowWithItem(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult hitResult, SnowVariant snowVariant) {
        Block block = Block.byItem((Item)itemStack.getItem());
        if (block == Blocks.AIR || !snowVariant.srm$getRaw(blockState, (BlockGetter)level, pos).isAir()) {
            return false;
        }
        BlockPlaceContext context = new BlockPlaceContext(player, interactionHand, itemStack, hitResult);
        if (!context.replacingClickedOnBlock()) {
            return false;
        }
        BlockState state2 = block.getStateForPlacement(context);
        if (state2 == null || !Hooks.canContainState(state2) || !state2.canSurvive((LevelReader)level, pos)) {
            return false;
        }
        if (!level.isClientSide) {
            SnowBlockEntity be;
            BlockEntity blockEntity;
            int i = (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS);
            boolean hasOverlay = false;
            if (i != 0 && (blockEntity = level.getBlockEntity(pos)) instanceof SnowBlockEntity) {
                be = (SnowBlockEntity)blockEntity;
                hasOverlay = be.options.renderOverlay;
            }
            level.setBlock(pos, state2, 48);
            block.setPlacedBy(level, pos, state2, (LivingEntity)player, context.getItemInHand());
            if (Hooks.placeLayersOn(level, pos, i, false, context, true, true)) {
                if (!player.isCreative()) {
                    context.getItemInHand().shrink(1);
                }
                if (hasOverlay && (blockEntity = level.getBlockEntity(pos)) instanceof SnowBlockEntity) {
                    be = (SnowBlockEntity)blockEntity;
                    be.options.renderOverlay = true;
                }
            }
        }
        return true;
    }

    public static boolean isFallable(BlockState blockState) {
        return SnowCommonConfig.snowGravity && (blockState.is(Blocks.SNOW) || blockState.is(CoreModule.SNOW_TAG));
    }

    public static void restoreOriginalBlocks(LevelChunk chunk) {
        Level level = chunk.getLevel();
        if (!SnowCommonConfig.restoreOriginalBlocks || level.isClientSide || level.getServer() == null || chunk.getBlockEntities().isEmpty()) {
            return;
        }
        ArrayList blockEntities = Lists.newArrayList();
        for (BlockEntity be : chunk.getBlockEntities().values()) {
            BlockState blockState = be.getBlockState();
            if (!(blockState.getBlock() instanceof SnowVariant)) continue;
            blockEntities.add(be);
        }
        if (blockEntities.isEmpty()) {
            return;
        }
        level.getServer().tell((Runnable)new TickTask(0, () -> {
            for (BlockEntity be : blockEntities) {
                Level level1 = be.getLevel();
                if (be.isRemoved() || level1 == null) continue;
                BlockState blockState = be.getBlockState();
                BlockPos pos = be.getBlockPos();
                BlockState raw = ((SnowVariant)blockState.getBlock()).srm$getRaw(blockState, (BlockGetter)level1, pos);
                if (raw.isAir()) {
                    raw = ((SnowVariant)blockState.getBlock()).srm$getSnowState(blockState, (BlockGetter)level1, pos);
                }
                level1.setBlock(pos, raw, 20);
                BlockPos below = pos.below();
                BlockState belowState = level1.getBlockState(below);
                if (!belowState.hasProperty((Property)BlockStateProperties.SNOWY) || !((Boolean)belowState.getValue((Property)BlockStateProperties.SNOWY)).booleanValue()) continue;
                level1.setBlock(below, (BlockState)belowState.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(false)), 20);
            }
        }));
    }
}

