/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.SnowWallBlock;

@NotNullByDefault
public class ShapeCaches {
    public static final Cache<Object, VoxelShape> VISUAL = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<Object, VoxelShape> COLLIDER = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final Cache<Object, VoxelShape> OUTLINE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public static VoxelShape get(Cache<Object, VoxelShape> cache, BlockState blockState, Function<BlockState, VoxelShape> shapeFunc) {
        return ShapeCaches.get(cache, blockState, shapeFunc, Shapes::or);
    }

    public static VoxelShape get(Cache<Object, VoxelShape> cache, BlockState blockState, Function<BlockState, VoxelShape> shapeFunc, BinaryOperator<VoxelShape> shapeMerger) {
        blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        VoxelShape shape = (VoxelShape)cache.getIfPresent((Object)(blockState = (BlockState)blockState.trySetValue((Property)StairBlock.HALF, (Comparable)Half.BOTTOM)));
        if (shape == null) {
            SnowVariant snowVariant = (SnowVariant)blockState.getBlock();
            int layers = snowVariant.srm$layers(blockState, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
            BlockState key = blockState;
            if (layers != 1 && blockState.getBlock() instanceof SnowWallBlock) {
                blockState = (BlockState)blockState.setValue((Property)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(1));
            }
            shape = shapeFunc.apply(blockState);
            if (layers != 0 && blockState.hasProperty((Property)SnowVariant.OPTIONAL_LAYERS)) {
                BlockState snowState = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers));
                VoxelShape snowShape = cache == VISUAL ? snowState.getOcclusionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO) : (cache == COLLIDER ? snowState.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty()) : snowState.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty()));
                shape = (VoxelShape)shapeMerger.apply(shape, snowShape);
            }
            cache.put((Object)key, (Object)shape);
        }
        return shape;
    }

    public static VoxelShape get(Cache<Object, VoxelShape> cache, BlockState blockState, BlockGetter level, BlockPos pos, Callable<? extends VoxelShape> loader) {
        blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        try {
            Key key;
            SnowVariant snowVariant = (SnowVariant)blockState.getBlock();
            int layers = snowVariant.srm$layers(blockState, level, pos);
            if (blockState.is(CoreModule.SNOW_TAG)) {
                BlockState raw = snowVariant.srm$getRaw(blockState, level, pos);
                Class<?> clazz = raw.getBlock().getClass();
                if (clazz != TallGrassBlock.class && clazz != TallFlowerBlock.class) {
                    return loader.call();
                }
                key = new Key(raw, layers);
            } else {
                key = new Key(blockState, layers);
            }
            return (VoxelShape)cache.get((Object)key, loader);
        }
        catch (Exception e) {
            SnowRealMagic.LOGGER.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void invalidateAll() {
        VISUAL.invalidateAll();
        COLLIDER.invalidateAll();
        OUTLINE.invalidateAll();
    }

    public record Key(BlockState state, int layers) {
    }
}

