/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.block.ShapeCaches;
import snownee.snow.block.WaterLoggableSnowVariant;
import snownee.snow.util.CommonProxy;

@NotNullByDefault
public class SnowStairsBlock
extends StairBlock
implements WaterLoggableSnowVariant {
    public SnowStairsBlock(BlockBehaviour.Properties properties) {
        super(Blocks.STONE.defaultBlockState(), properties);
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return super.getShape(blockState, blockGetter, blockPos, collisionContext);
    }

    protected VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return ShapeCaches.get(ShapeCaches.VISUAL, blockState, it -> {
            VoxelShape shape = this.getShape((BlockState)it, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty());
            return Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.AND);
        });
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCaches.get(ShapeCaches.OUTLINE, blockState, it -> {
            VoxelShape shape = super.getShape(it, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty()).move(0.0, 0.125, 0.0);
            return Shapes.or((VoxelShape)shape, (VoxelShape)Blocks.OAK_SLAB.defaultBlockState().getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
        });
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && state.getBlock() != newState.getBlock()) {
            worldIn.removeBlockEntity(pos);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (CommonProxy.shouldMelt((Level)worldIn, pos)) {
            worldIn.setBlockAndUpdate(pos, this.srm$getRaw(state, (BlockGetter)worldIn, pos));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)HALF, (Comparable)Half.BOTTOM);
    }

    @Override
    public boolean srm$canRenderDecoration(BlockState blockState) {
        return true;
    }

    @Override
    public boolean srm$canRenderOverlay(BlockState blockState) {
        return false;
    }
}

