/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.GameEvents;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.mixin.BlockAccess;
import snownee.snow.util.WrappedSoundType;

@NotNullByDefault
public interface SnowVariant
extends IKiwiBlock {
    public static final IntegerProperty OPTIONAL_LAYERS = IntegerProperty.create((String)"layers", (int)0, (int)8);

    default public BlockState srm$getRaw(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        if (state.hasBlockEntity() && (blockEntity = level.getBlockEntity(pos)) instanceof SnowBlockEntity) {
            SnowBlockEntity be = (SnowBlockEntity)blockEntity;
            return be.getContainedState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    default public BlockState srm$decreaseLayer(BlockState state, Level level, BlockPos pos, boolean byPlayer) {
        return this.srm$getRaw(state, (BlockGetter)level, pos);
    }

    default public ItemStack getCloneItemStack(BlockState state, HitResult result, LevelReader level, BlockPos pos, Player player) {
        BlockState raw = this.srm$getRaw(state, (BlockGetter)level, pos);
        if (raw.isAir()) {
            return Items.SNOW.getDefaultInstance();
        }
        return raw.getCloneItemStack(result, level, pos, player);
    }

    default public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        if (state.hasBlockEntity() && !(state.getBlock() instanceof SnowLayerBlock)) {
            return WrappedSoundType.get(this.srm$getRaw(state, (BlockGetter)level, pos).getSoundType(level, pos, entity));
        }
        return super.getSoundType(state, level, pos, entity);
    }

    default public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos sourcePos) {
        if (this.srm$layers(state, (BlockGetter)level, pos) > 0 && queryState != null && queryState.is(BlockTags.SNOW)) {
            return this.srm$getSnowState(state, (BlockGetter)level, pos);
        }
        return this.srm$getRaw(state, (BlockGetter)level, pos);
    }

    default public int srm$layers(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    default public int srm$maxLayers(BlockState state, Level level, BlockPos pos2) {
        return 0;
    }

    default public BlockState srm$getSnowState(BlockState state, BlockGetter level, BlockPos pos) {
        int layers = this.srm$layers(state, level, pos);
        return layers == 0 ? Blocks.AIR.defaultBlockState() : (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers));
    }

    default public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            state.getBlock().playerWillDestroy(level, pos, state, player);
        } else {
            ((BlockAccess)state.getBlock()).callSpawnDestroyParticles(level, player, pos, state);
        }
        if (GameEvents.onDestroyedByPlayer(level, player, pos, state, level.getBlockEntity(pos))) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        return true;
    }

    default public boolean srm$canRenderDecoration(BlockState blockState) {
        return false;
    }

    default public double srm$renderDecorationOffset(BlockState blockState) {
        return 0.125;
    }

    default public boolean srm$canRenderOverlay(BlockState blockState) {
        return true;
    }

    default public double srm$renderLayerOffset(BlockState blockState) {
        return 0.0;
    }
}

