/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.convert;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.convert.BlockConverter;
import snownee.snow.convert.CoveredBlockConverter;
import snownee.snow.util.KeyedList;

@NotNullByDefault
public class BlockConverters {
    public final KeyedList<ResourceLocation, BlockConverter> converters = new KeyedList();
    public final KeyedList<ResourceLocation, BlockConverter> airConverters = new KeyedList(1);
    private final Object2ObjectLinkedOpenHashMap<BlockState, @Nullable BlockConverter> cache = new Object2ObjectLinkedOpenHashMap();

    public void add(ResourceLocation id, BlockConverter converter) {
        if (converter.acceptAir()) {
            this.airConverters.putLast(id, converter);
        } else {
            this.converters.putLast(id, converter);
        }
    }

    @Nullable
    public BlockConverter of(BlockState blockState) {
        BlockConverter converter = (BlockConverter)this.cache.computeIfAbsent((Object)blockState, this::ofInternal);
        if (this.cache.size() > 1024) {
            this.cache.removeFirst();
        }
        return converter;
    }

    @Nullable
    private BlockConverter ofInternal(BlockState blockState) {
        for (BlockConverter converter : blockState.isAir() ? this.airConverters : this.converters) {
            if (!converter.takeIn(blockState)) continue;
            return converter.accept(blockState) ? converter : null;
        }
        return null;
    }

    public void initSnow() {
        this.add(SnowRealMagic.id("air"), new BlockConverter(this){

            @Override
            public boolean takeIn(BlockState blockState) {
                return true;
            }

            @Override
            public boolean acceptAir() {
                return true;
            }

            @Override
            public BlockState convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers) {
                Block block = Blocks.SNOW;
                if (SnowCommonConfig.fancySnowOnUpperSlab && level.getBlockState(pos.below()).getBlock() instanceof SlabBlock) {
                    block = (Block)CoreModule.SNOW_BLOCK.get();
                }
                return block.defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("double_plant"), new BlockConverter(this){

            @Override
            public boolean takeIn(BlockState blockState) {
                return blockState.getBlock() instanceof DoublePlantBlock;
            }

            @Override
            public BlockState convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers) {
                if (blockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER) {
                    return CoreModule.SNOWY_DOUBLE_PLANT_LOWER.defaultBlockState();
                }
                return CoreModule.SNOWY_DOUBLE_PLANT_UPPER.defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("slab"), new CoveredBlockConverter(this, SlabBlock.class, CoreModule.SLAB.defaultBlockState()){

            @Override
            public boolean accept(BlockState blockState) {
                return blockState.getValue((Property)SlabBlock.TYPE) == SlabType.BOTTOM;
            }

            @Override
            public BlockState convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers) {
                return this.result;
            }
        });
        this.add(SnowRealMagic.id("stairs"), new CoveredBlockConverter(this, StairBlock.class, CoreModule.STAIRS.defaultBlockState()){

            @Override
            public boolean accept(BlockState blockState) {
                return super.accept(blockState) && blockState.getValue((Property)StairBlock.HALF) == Half.BOTTOM;
            }
        });
        this.add(SnowRealMagic.id("wall"), new CoveredBlockConverter(WallBlock.class, CoreModule.WALL.defaultBlockState()));
        this.add(SnowRealMagic.id("fence"), new CoveredBlockConverter(this, FenceBlock.class, CoreModule.FENCE.defaultBlockState()){

            @Override
            public BlockState result(BlockState blockState) {
                return (blockState.getSoundType() == SoundType.WOOD || blockState.is(BlockTags.WOODEN_FENCES) ? CoreModule.FENCE : CoreModule.FENCE2).defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("fence_gate"), new CoveredBlockConverter(FenceGateBlock.class, CoreModule.FENCE_GATE.defaultBlockState()));
        this.add(SnowRealMagic.id("plant"), new BlockConverter(this){

            @Override
            public boolean takeIn(BlockState blockState) {
                return blockState.is(CoreModule.PLANTS);
            }

            @Override
            public BlockState convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers) {
                return CoreModule.SNOWY_PLANT.defaultBlockState();
            }
        });
        this.add(SnowRealMagic.id("fallback"), new BlockConverter(this){

            @Override
            public boolean takeIn(BlockState blockState) {
                Block block = blockState.getBlock();
                return block instanceof TallGrassBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock || blockState.is(CoreModule.CONTAINABLES);
            }

            @Override
            public BlockState convert(LevelAccessor level, BlockPos pos, BlockState blockState, int layers) {
                return (blockState.getCollisionShape((BlockGetter)level, pos).isEmpty() ? CoreModule.SNOW_BLOCK : CoreModule.SNOW_EXTRA_COLLISION_BLOCK).defaultBlockState();
            }
        });
    }
}

