/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.snow.CoreModule;
import snownee.snow.block.SRMSnowLayerBlock;

@Mixin(value={DoublePlantBlock.class})
public class DoublePlantBlockMixin {
    @Shadow
    @Final
    public static EnumProperty<DoubleBlockHalf> HALF;

    @Inject(method={"preventDropFromBottomPart"}, at={@At(value="TAIL")})
    private static void srm_preventDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player, CallbackInfo ci, @Local DoubleBlockHalf doubleBlockHalf) {
        if (doubleBlockHalf != DoubleBlockHalf.UPPER) {
            return;
        }
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (!CoreModule.SNOWY_DOUBLE_PLANT_LOWER.is(belowState)) {
            return;
        }
        level.setBlock(belowPos, Blocks.AIR.defaultBlockState(), 35);
        level.setBlock(belowPos, ((SRMSnowLayerBlock)CoreModule.SNOWY_DOUBLE_PLANT_LOWER.get()).srm$getSnowState(belowState, (BlockGetter)level, belowPos), 35);
        level.levelEvent(player, 2001, belowPos, Block.getId((BlockState)state));
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void srm_updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> cir) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && facing == Direction.DOWN && CoreModule.SNOWY_DOUBLE_PLANT_LOWER.is(facingState)) {
            cir.setReturnValue((Object)stateIn);
        }
        if (doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.UP && CoreModule.SNOWY_DOUBLE_PLANT_UPPER.is(facingState)) {
            cir.setReturnValue((Object)stateIn);
        }
    }

    @Inject(method={"canSurvive"}, at={@At(value="HEAD")}, cancellable=true)
    public void srm_canSurvive(BlockState state, LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER && CoreModule.SNOWY_DOUBLE_PLANT_LOWER.is(level.getBlockState(pos.below()))) {
            cir.setReturnValue((Object)true);
        }
    }
}

