/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.network.SLavaSmokeEffectPacket;
import snownee.snow.util.CommonProxy;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends Entity {
    @Unique
    @Nullable
    private BlockPos srm$oBlockPos;
    @Shadow
    private BlockState blockState;
    @Shadow
    private boolean hurtEntities;
    @Shadow
    public boolean dropItem;

    public FallingBlockEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="RETURN")})
    private void srm_init(Level level, double x, double y, double z, BlockState blockState, CallbackInfo ci) {
        if (this.blockState.is(Blocks.SNOW)) {
            this.hurtEntities = false;
            this.dropItem = false;
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/FallingBlockEntity;blockPosition()Lnet/minecraft/core/BlockPos;")}, cancellable=true)
    private void srm_touchLiquid(CallbackInfo ci) {
        if (!this.blockState.is(Blocks.SNOW)) {
            return;
        }
        BlockPos pos = this.blockPosition();
        if (this.srm$oBlockPos != null && this.srm$oBlockPos.equals((Object)pos)) {
            return;
        }
        this.srm$oBlockPos = pos;
        BlockState blockState = this.level().getBlockState(pos);
        boolean handled = true;
        if (SnowCommonConfig.snowMakingIce && blockState.is(Blocks.WATER)) {
            this.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
        } else if (CommonProxy.isHot(blockState.getFluidState(), this.level(), pos)) {
            new SLavaSmokeEffectPacket(pos.above()).sendToAround((ServerLevel)this.level());
        } else if (blockState.getFluidState().isEmpty()) {
            handled = false;
        }
        if (handled) {
            this.discard();
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canBeReplaced(Lnet/minecraft/world/item/context/BlockPlaceContext;)Z")}, cancellable=true)
    private void srm_touchGround(CallbackInfo ci) {
        if (!this.blockState.is(Blocks.SNOW)) {
            return;
        }
        BlockPos pos = this.getOnPos();
        BlockState blockIn = this.level().getBlockState(pos);
        if (!Hooks.canPlaceAt(this.level(), pos) && !(blockIn.getBlock() instanceof SnowVariant)) {
            pos = this.blockPosition();
        }
        Hooks.placeLayersOn(this.level(), pos, (Integer)this.blockState.getValue((Property)SnowLayerBlock.LAYERS), true, (BlockPlaceContext)new DirectionalPlaceContext(this.level(), pos, Direction.DOWN, ItemStack.EMPTY, Direction.UP), true, true);
        this.discard();
        ci.cancel();
    }
}

