/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.level.block.SoundType;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public final class WrappedSoundType
extends SoundType {
    private static final Map<SoundType, SoundType> wrappedSounds = Maps.newConcurrentMap();

    private WrappedSoundType(SoundType type) {
        super(type.getVolume(), type.getPitch(), type.getBreakSound(), SoundType.SNOW.getStepSound(), SoundType.SNOW.getFallSound(), SoundType.SNOW.getPlaceSound(), type.getHitSound());
    }

    public static SoundType get(SoundType soundType) {
        if (soundType == SoundType.SNOW || soundType instanceof WrappedSoundType) {
            return soundType;
        }
        return wrappedSounds.computeIfAbsent(soundType, WrappedSoundType::new);
    }
}

