/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import moze_intel.projecte.api.nss.NSSItem;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemInfo {
    public static final MapCodec<ItemInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(ItemInfo::getItem), (App)DataComponentPatch.CODEC.optionalFieldOf("data", (Object)DataComponentPatch.EMPTY).forGetter(ItemInfo::getComponentsPatch)).apply((Applicative)instance, ItemInfo::new));
    public static final Codec<ItemInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), ItemInfo::getItem, (StreamCodec)DataComponentPatch.STREAM_CODEC, ItemInfo::getComponentsPatch, ItemInfo::new);
    @NotNull
    private final Holder<Item> item;
    @NotNull
    private final DataComponentPatch componentsPatch;
    private boolean hasCachedHash;
    private int cachedHashCode;

    private ItemInfo(@NotNull Holder<Item> item, @NotNull DataComponentPatch componentsPatch) {
        this.item = item;
        this.componentsPatch = componentsPatch;
    }

    public static ItemInfo fromItem(@NotNull ItemLike itemLike, @NotNull DataComponentPatch componentsPatch) {
        return new ItemInfo((Holder<Item>)itemLike.asItem().builtInRegistryHolder(), componentsPatch);
    }

    public static ItemInfo fromItem(@NotNull Holder<Item> holder, @NotNull DataComponentPatch componentsPatch) {
        if (holder.kind() == Holder.Kind.DIRECT) {
            if (!holder.isBound()) {
                throw new IllegalArgumentException("ItemInfo does not support unbound direct holders.");
            }
            if ((holder = BuiltInRegistries.ITEM.wrapAsHolder((Object)((Item)holder.value()))).kind() == Holder.Kind.DIRECT) {
                throw new IllegalArgumentException("ItemInfo does not support direct holders for unregistered items.");
            }
        }
        return new ItemInfo(holder, componentsPatch);
    }

    public static ItemInfo fromItem(@NotNull ItemLike itemLike) {
        return ItemInfo.fromItem((Holder<Item>)itemLike.asItem().builtInRegistryHolder(), DataComponentPatch.EMPTY);
    }

    public static ItemInfo fromItem(@NotNull Holder<Item> holder) {
        return ItemInfo.fromItem(holder, DataComponentPatch.EMPTY);
    }

    public static ItemInfo fromStack(@NotNull ItemStack stack) {
        return new ItemInfo((Holder<Item>)stack.getItemHolder(), stack.getComponentsPatch());
    }

    @Nullable
    public static ItemInfo fromNSS(@NotNull NSSItem stack) {
        if (stack.representsTag()) {
            return null;
        }
        Optional holder = BuiltInRegistries.ITEM.getHolder(stack.getResourceLocation());
        if (holder.isEmpty()) {
            return null;
        }
        return ItemInfo.fromItem((Holder<Item>)((Holder)holder.get()), stack.getComponentsPatch());
    }

    public NSSItem toNSS() {
        return NSSItem.createItem(this.item, this.componentsPatch);
    }

    @NotNull
    public Holder<Item> getItem() {
        return this.item;
    }

    @NotNull
    public DataComponentPatch getComponentsPatch() {
        return this.componentsPatch;
    }

    public boolean hasModifiedComponents() {
        return !this.componentsPatch.isEmpty();
    }

    @Nullable
    public <T> T getOrNull(DataComponentType<? extends T> type) {
        Optional storedComponent = this.componentsPatch.get(type);
        if (storedComponent == null || storedComponent.isEmpty()) {
            return null;
        }
        return storedComponent.get();
    }

    public ItemInfo itemOnly() {
        return this.componentsPatch.isEmpty() ? this : ItemInfo.fromItem(this.item);
    }

    public ItemStack createStack() {
        return new ItemStack(this.getItem(), 1, this.getComponentsPatch());
    }

    public int hashCode() {
        if (!this.hasCachedHash) {
            this.hasCachedHash = true;
            ResourceKey resourceKey = this.item.getKey();
            int code = resourceKey == null ? 0 : resourceKey.hashCode();
            this.cachedHashCode = 31 * code + this.componentsPatch.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ItemInfo) {
            ItemInfo other = (ItemInfo)o;
            return this.item.is(other.item) && this.componentsPatch.equals((Object)other.componentsPatch);
        }
        return false;
    }

    public String toString() {
        if (this.componentsPatch.isEmpty()) {
            return this.item.getRegisteredName();
        }
        return this.item.getRegisteredName() + " " + String.valueOf(this.componentsPatch);
    }
}

