/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.capabilities.item;

import moze_intel.projecte.api.PEDataComponents;
import moze_intel.projecte.api.PESounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IItemCharge {
    public int getNumCharges(@NotNull ItemStack var1);

    default public float getChargePercent(@NotNull ItemStack stack) {
        return (float)this.getCharge(stack) / (float)this.getNumCharges(stack);
    }

    default public int getCharge(@NotNull ItemStack stack) {
        return Mth.clamp((int)((Integer)stack.getOrDefault(PEDataComponents.CHARGE, (Object)0)), (int)0, (int)this.getNumCharges(stack));
    }

    default public boolean changeCharge(@NotNull Player player, @NotNull ItemStack stack, @Nullable InteractionHand hand) {
        int currentCharge = this.getCharge(stack);
        int numCharges = this.getNumCharges(stack);
        if (player.isSecondaryUseActive()) {
            if (currentCharge > 0) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESounds.UNCHARGE.value(), SoundSource.PLAYERS, 1.0f, 0.5f + 0.5f / (float)numCharges * (float)currentCharge);
                stack.set(PEDataComponents.CHARGE, (Object)(currentCharge - 1));
                return true;
            }
        } else if (currentCharge < numCharges) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESounds.CHARGE.value(), SoundSource.PLAYERS, 1.0f, 0.5f + 0.5f / (float)numCharges * (float)currentCharge);
            stack.set(PEDataComponents.CHARGE, (Object)(currentCharge + 1));
            return true;
        }
        return false;
    }
}

