/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NSSDataComponentHolder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataComponentHolderNSSTag<TYPE>
extends AbstractNSSTag<TYPE>
implements NSSDataComponentHolder {
    @NotNull
    private final DataComponentPatch componentsPatch;
    private boolean hasCachedHash;
    private int cachedHashCode;

    protected AbstractDataComponentHolderNSSTag(@NotNull ResourceLocation resourceLocation, boolean isTag, @NotNull DataComponentPatch componentsPatch) {
        super(resourceLocation, isTag);
        this.componentsPatch = Objects.requireNonNull(componentsPatch, "Components patch must not be null");
    }

    @Override
    @NotNull
    public DataComponentPatch getComponentsPatch() {
        return this.componentsPatch;
    }

    @Override
    public String toString() {
        if (this.componentsPatch == null || this.componentsPatch.isEmpty()) {
            return super.toString();
        }
        return super.toString() + " " + String.valueOf(this.componentsPatch);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || super.equals(o) && Objects.equals(this.componentsPatch, ((AbstractDataComponentHolderNSSTag)o).componentsPatch);
    }

    @Override
    public int hashCode() {
        if (this.componentsPatch == null) {
            this.hasCachedHash = true;
            this.cachedHashCode = Objects.hash(super.hashCode(), DataComponentPatch.EMPTY);
        } else if (!this.hasCachedHash) {
            this.hasCachedHash = true;
            this.cachedHashCode = Objects.hash(super.hashCode(), this.componentsPatch);
        }
        return this.cachedHashCode;
    }

    protected static <TYPE, NSS extends AbstractDataComponentHolderNSSTag<TYPE>> MapCodec<NSS> createCodec(Registry<TYPE> registry, boolean allowDefault, DataComponentHolderNSSConstructor<TYPE, NSS> nssConstructor) {
        return NeoForgeExtraCodecs.withAlternative(AbstractDataComponentHolderNSSTag.createTagCodec(nssConstructor), (MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group(AbstractDataComponentHolderNSSTag.idComponent(registry, allowDefault), (App)DataComponentPatch.CODEC.optionalFieldOf("data", (Object)DataComponentPatch.EMPTY).forGetter(AbstractDataComponentHolderNSSTag::getComponentsPatch)).apply((Applicative)instance, nssConstructor::create)));
    }

    @FunctionalInterface
    protected static interface DataComponentHolderNSSConstructor<TYPE, NSS extends AbstractDataComponentHolderNSSTag<TYPE>>
    extends AbstractNSSTag.NSSTagConstructor<TYPE, NSS> {
        public NSS create(ResourceLocation var1, boolean var2, @NotNull DataComponentPatch var3);

        @Override
        default public NSS create(ResourceLocation rl, boolean isTag) {
            return this.create(rl, isTag, DataComponentPatch.EMPTY);
        }

        default public NSS create(ResourceLocation rl, @NotNull DataComponentPatch componentsPatch) {
            return this.create(rl, false, componentsPatch);
        }
    }
}

