/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import moze_intel.projecte.api.nss.AbstractDataComponentHolderNSSTag;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public final class NSSItem
extends AbstractDataComponentHolderNSSTag<Item> {
    private static final ResourceKey<Item> DEFAULT_KEY = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BuiltInRegistries.ITEM.getDefaultKey());
    public static final MapCodec<NSSItem> CODEC = NSSItem.createCodec(BuiltInRegistries.ITEM, false, NSSItem::new);

    private NSSItem(@NotNull ResourceLocation resourceLocation, boolean isTag, @NotNull DataComponentPatch componentsPatch) {
        super(resourceLocation, isTag, componentsPatch);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        return NSSItem.createItem((Holder<Item>)stack.getItemHolder(), stack.getComponentsPatch());
    }

    @NotNull
    public static NSSItem createItem(@NotNull ItemLike itemProvider) {
        return NSSItem.createItem(itemProvider, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSItem createItem(@NotNull Holder<Item> item) {
        return NSSItem.createItem(item, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSItem createItem(@NotNull Holder<Item> itemHolder, @NotNull DataComponentPatch componentsPatch) {
        ResourceKey key = itemHolder.getKey();
        if (key == null) {
            if (!itemHolder.isBound()) {
                throw new IllegalArgumentException("Can't make an NSSItem with an unbound direct holder");
            }
            Optional registryKey = BuiltInRegistries.ITEM.getResourceKey((Object)((Item)itemHolder.value()));
            if (registryKey.isEmpty()) {
                throw new IllegalArgumentException("Can't make an NSSItem with an unregistered item");
            }
            key = (ResourceKey)registryKey.get();
        }
        if (key == DEFAULT_KEY) {
            throw new IllegalArgumentException("Can't make NSSItem with an empty stack");
        }
        return NSSItem.createItem(key.location(), componentsPatch);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ItemLike itemProvider, @NotNull DataComponentPatch componentsPatch) {
        return NSSItem.createItem((Holder<Item>)itemProvider.asItem().builtInRegistryHolder(), componentsPatch);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ResourceLocation itemID) {
        return NSSItem.createItem(itemID, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSItem createItem(@NotNull ResourceKey<Item> itemID) {
        return NSSItem.createItem(itemID.location());
    }

    @NotNull
    public static NSSItem createItem(@NotNull ResourceLocation itemID, @NotNull DataComponentPatch componentsPatch) {
        return new NSSItem(itemID, false, componentsPatch);
    }

    @NotNull
    public static NSSItem createTag(@NotNull ResourceLocation tagId) {
        return new NSSItem(tagId, true, DataComponentPatch.EMPTY);
    }

    @NotNull
    public static NSSItem createTag(@NotNull TagKey<Item> tag) {
        return NSSItem.createTag(tag.location());
    }

    @Override
    @NotNull
    protected Registry<Item> getRegistry() {
        return BuiltInRegistries.ITEM;
    }

    protected NSSItem createNew(Holder<Item> item) {
        return NSSItem.createItem(item);
    }

    public MapCodec<NSSItem> codec() {
        return CODEC;
    }
}

