/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import moze_intel.projecte.PECore;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import org.jetbrains.annotations.ApiStatus;

public record GemData(boolean isWhitelist, Set<ItemStack> whitelist, List<ItemStack> consumed) {
    public static final GemData EMPTY = new GemData(false, Collections.emptySet(), Collections.emptyList());
    public static final Codec<GemData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("isWhitelist").forGetter(GemData::isWhitelist), (App)ItemStack.SINGLE_ITEM_CODEC.sizeLimitedListOf(9).promotePartial(error -> PECore.LOGGER.error("Failed to load gem whitelist: {}", error)).xmap(list -> {
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        Set whitelist = ItemStackLinkedSet.createTypeAndComponentsSet();
        whitelist.addAll(list);
        return whitelist;
    }, List::copyOf).fieldOf("whitelist").forGetter(GemData::whitelist), (App)ItemStack.CODEC.listOf().promotePartial(error -> PECore.LOGGER.error("Failed to load gem consumed contents: {}", error)).fieldOf("consumed").forGetter(GemData::consumed)).apply((Applicative)instance, GemData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GemData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, GemData::isWhitelist, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.collection(size -> new ObjectLinkedOpenCustomHashSet(size, ItemStackLinkedSet.TYPE_AND_TAG))), GemData::whitelist, (StreamCodec)ItemStack.LIST_STREAM_CODEC, GemData::consumed, GemData::new);

    public GemData {
        whitelist = whitelist.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(whitelist);
        consumed = consumed.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(consumed);
    }

    public boolean whitelistMatches(ItemStack stack) {
        return !stack.isEmpty() && this.whitelist.contains(stack);
    }

    public GemData withWhitelist(boolean isWhitelist) {
        if (isWhitelist == this.isWhitelist()) {
            return this;
        }
        return new GemData(isWhitelist, this.whitelist, this.consumed);
    }

    public GemData withWhitelist(Set<ItemStack> whitelist) {
        Set newWhitelist = ItemStackLinkedSet.createTypeAndComponentsSet();
        for (ItemStack stack : whitelist) {
            newWhitelist.add(stack.copyWithCount(1));
        }
        return this.withWhitelistSafe(newWhitelist);
    }

    @ApiStatus.Internal
    public GemData withWhitelistSafe(Set<ItemStack> whitelist) {
        if (whitelist.isEmpty() && this.whitelist().isEmpty()) {
            return this;
        }
        return new GemData(this.isWhitelist, whitelist, this.consumed);
    }

    public GemData clearConsumed() {
        if (this.consumed().isEmpty()) {
            return this;
        }
        return new GemData(this.isWhitelist, this.whitelist, Collections.emptyList());
    }

    public GemData addConsumed(ItemStack stack) {
        if (stack.isEmpty()) {
            return this;
        }
        ArrayList<ItemStack> modifiableConsumed = new ArrayList<ItemStack>(this.consumed);
        int size = modifiableConsumed.size();
        for (int i = 0; i < size; ++i) {
            ItemStack existing = (ItemStack)modifiableConsumed.get(i);
            int maxStackSize = existing.getMaxStackSize();
            if (existing.getCount() >= maxStackSize || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) continue;
            int spaceAvailable = maxStackSize - existing.getCount();
            if (stack.getCount() <= spaceAvailable) {
                existing = existing.copyWithCount(existing.getCount() + stack.getCount());
                modifiableConsumed.set(i, existing);
                return new GemData(this.isWhitelist, this.whitelist, modifiableConsumed);
            }
            existing = existing.copyWithCount(existing.getCount() + spaceAvailable);
            modifiableConsumed.set(i, existing);
            stack.shrink(spaceAvailable);
        }
        modifiableConsumed.add(stack);
        return new GemData(this.isWhitelist, this.whitelist, modifiableConsumed);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GemData other = (GemData)o;
        return this.isWhitelist == other.isWhitelist && this.whitelist.equals(other.whitelist) && ItemStack.listMatches(this.consumed, other.consumed);
    }

    @Override
    public int hashCode() {
        int hash = 31 * Boolean.hashCode(this.isWhitelist) + GemData.hashStackSet(this.whitelist);
        return 31 * hash + ItemStack.hashStackList(this.consumed);
    }

    private static int hashStackSet(Set<ItemStack> set) {
        int i = 0;
        for (ItemStack stack : set) {
            i = i * 31 + ItemStack.hashItemAndComponents((ItemStack)stack);
        }
        return i;
    }
}

