/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.config.ClientConfig;
import moze_intel.projecte.config.CommonConfig;
import moze_intel.projecte.config.IPEConfig;
import moze_intel.projecte.config.ServerConfig;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;

public class ProjectEConfig {
    public static final Path CONFIG_DIR = FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("ProjectE"));
    private static final Map<IConfigSpec, IPEConfig> KNOWN_CONFIGS = new HashMap<IConfigSpec, IPEConfig>();
    public static final ServerConfig server = new ServerConfig();
    public static final CommonConfig common = new CommonConfig();
    public static final ClientConfig client = new ClientConfig();

    public static void register(ModContainer modContainer) {
        ProjectEConfig.registerConfig(modContainer, server);
        ProjectEConfig.registerConfig(modContainer, common);
        ProjectEConfig.registerConfig(modContainer, client);
    }

    public static Collection<IPEConfig> getConfigs() {
        return Collections.unmodifiableCollection(KNOWN_CONFIGS.values());
    }

    public static void registerConfig(ModContainer modContainer, IPEConfig config) {
        modContainer.registerConfig(config.getConfigType(), (IConfigSpec)config.getConfigSpec(), "ProjectE/" + config.getFileName() + ".toml");
        KNOWN_CONFIGS.put((IConfigSpec)config.getConfigSpec(), config);
    }

    public static void onConfigLoad(ModConfigEvent event) {
        IPEConfig peConfig;
        ModConfig config = event.getConfig();
        if (config.getModId().equals("projecte") && (peConfig = KNOWN_CONFIGS.get(config.getSpec())) != null) {
            peConfig.clearCache(event instanceof ModConfigEvent.Unloading);
        }
    }
}

