/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.components.processor;

import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.DataComponentProcessor;
import moze_intel.projecte.api.components.IDataComponentProcessor;
import moze_intel.projecte.config.PEConfigTranslations;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@DataComponentProcessor(priority=0x7FFFFFFF)
public class DamageProcessor
implements IDataComponentProcessor {
    @DataComponentProcessor.Instance
    public static final DamageProcessor INSTANCE = new DamageProcessor();

    @Override
    public String getName() {
        return PEConfigTranslations.DCP_DAMAGE.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.DCP_DAMAGE.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.DCP_DAMAGE.tooltip();
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long recalculateEMC(@NotNull ItemInfo info, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long currentEMC) throws ArithmeticException {
        ItemStack fakeStack = info.createStack();
        if (fakeStack.isDamaged()) {
            int maxDamage = fakeStack.getMaxDamage();
            int remainingDurability = maxDamage - fakeStack.getDamageValue();
            if (remainingDurability == 0) {
                return 0L;
            }
            if (remainingDurability == 1) {
                currentEMC /= (long)maxDamage;
            } else if (remainingDurability > 1) {
                currentEMC = Math.multiplyExact(currentEMC, remainingDurability) / (long)maxDamage;
            }
        }
        return currentEMC;
    }
}

