/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@EMCMapper
public class BrewingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, ReloadableServerResources serverResources, RegistryAccess registryAccess, ResourceManager resourceManager) {
        ItemStack output;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            PECore.LOGGER.error("Failed to get server and potion data when trying to map potions");
            return;
        }
        PotionBrewing potionBrewing = server.potionBrewing();
        Set<ItemInfo> allReagents = this.mapAllReagents(potionBrewing);
        Set<ItemInfo> allInputs = this.mapAllInputs(potionBrewing);
        mapper.addConversion(1, (NormalizedSimpleStack)NSSItem.createItem(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)), EMCHelper.intMapOf(NSSItem.createItem((ItemLike)Items.GLASS_BOTTLE), 1, NSSFluid.createTag((TagKey<Fluid>)FluidTags.WATER), 333));
        int recipeCount = 0;
        for (ItemInfo inputInfo : allInputs) {
            ItemStack validInput = inputInfo.createStack();
            NSSItem nssInput = inputInfo.toNSS();
            for (ItemInfo reagentInfo : allReagents) {
                output = potionBrewing.mix(reagentInfo.createStack(), validInput);
                if (output.isEmpty()) continue;
                mapper.addConversion(3 * output.getCount(), (NormalizedSimpleStack)NSSItem.createItem(output), EMCHelper.intMapOf(nssInput, 3, reagentInfo.toNSS(), 1));
                ++recipeCount;
            }
        }
        HashSet<Class> canNotMap = new HashSet<Class>();
        for (IBrewingRecipe recipe : potionBrewing.getRecipes()) {
            if (recipe instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
                ItemStack[] validInputs = BrewingMapper.getMatchingStacks(brewingRecipe.getInput());
                ItemStack[] validReagents = BrewingMapper.getMatchingStacks(brewingRecipe.getIngredient());
                if (validInputs == null || validReagents == null) continue;
                output = brewingRecipe.getOutput();
                NSSItem nssOut = NSSItem.createItem(output);
                for (ItemStack validInput : validInputs) {
                    NSSItem nssInput = NSSItem.createItem(validInput);
                    for (ItemStack validReagent : validReagents) {
                        mapper.addConversion(3 * output.getCount(), (NormalizedSimpleStack)nssOut, EMCHelper.intMapOf(nssInput, 3, NSSItem.createItem(validReagent), validReagent.getCount()));
                        ++recipeCount;
                    }
                }
                continue;
            }
            canNotMap.add(recipe.getClass());
        }
        PECore.debugLog("{} Statistics:", this.getName());
        PECore.debugLog("Found {} Brewing Recipes", recipeCount);
        for (Class c : canNotMap) {
            PECore.debugLog("Could not map Brewing Recipes with Type: {}", c.getName());
        }
    }

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_BREWING_MAPPER.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_BREWING_MAPPER.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_BREWING_MAPPER.tooltip();
    }

    @Nullable
    private static ItemStack[] getMatchingStacks(Ingredient ingredient) {
        try {
            return ingredient.getItems();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Set<ItemInfo> mapAllReagents(PotionBrewing potionBrewing) {
        HashSet<ItemInfo> allReagents = new HashSet<ItemInfo>();
        this.addReagents(allReagents, potionBrewing.containerMixes);
        this.addReagents(allReagents, potionBrewing.potionMixes);
        return allReagents;
    }

    private <T> void addReagents(Set<ItemInfo> allReagents, List<PotionBrewing.Mix<T>> conversions) {
        for (PotionBrewing.Mix<T> conversion : conversions) {
            for (ItemStack r : conversion.ingredient().getItems()) {
                allReagents.add(ItemInfo.fromStack(r));
            }
        }
    }

    private Set<ItemInfo> mapAllInputs(PotionBrewing potionBrewing) {
        HashSet<ItemInfo> allInputs = new HashSet<ItemInfo>();
        HashSet<ItemInfo> inputs = new HashSet<ItemInfo>();
        for (Ingredient potionItem : potionBrewing.containers) {
            ItemStack[] matchingStacks = BrewingMapper.getMatchingStacks(potionItem);
            if (matchingStacks == null) continue;
            for (ItemStack input : matchingStacks) {
                inputs.add(ItemInfo.fromStack(input));
            }
        }
        for (Holder potion : BuiltInRegistries.POTION.holders().toList()) {
            PotionContents contents = new PotionContents(potion);
            for (ItemInfo input : inputs) {
                ItemStack stack = input.createStack();
                stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
                allInputs.add(ItemInfo.fromStack(stack));
            }
        }
        return allInputs;
    }
}

