/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe.special;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.PEConfigTranslations;
import moze_intel.projecte.emc.mappers.recipe.special.SpecialRecipeMapper;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.DecoratedPotRecipe;
import net.minecraft.world.level.block.entity.PotDecorations;

public class DecoratedPotMapper
extends SpecialRecipeMapper<DecoratedPotRecipe> {
    private static final ResourceLocation DECORATED_POT = BuiltInRegistries.ITEM.getKey((Object)Items.DECORATED_POT);

    @Override
    protected Class<DecoratedPotRecipe> getRecipeClass() {
        return DecoratedPotRecipe.class;
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RegistryAccess registryAccess, INSSFakeGroupManager fakeGroupManager) {
        Optional tag = BuiltInRegistries.ITEM.getTag(ItemTags.DECORATED_POT_INGREDIENTS);
        if (tag.isEmpty()) {
            return false;
        }
        int recipeCount = 0;
        int uniqueInputs = 0;
        HolderSet.Named ingredients = (HolderSet.Named)tag.get();
        int size = ingredients.size();
        record IngredientData(Item item, NSSItem nss) {
        }
        ArrayList<IngredientData> ingredientData = new ArrayList<IngredientData>(size);
        for (Holder ingredient : ingredients) {
            ingredientData.add(new IngredientData((Item)ingredient.value(), NSSItem.createItem((Holder<Item>)ingredient)));
        }
        for (IngredientData back : ingredientData) {
            for (IngredientData left : ingredientData) {
                for (IngredientData right : ingredientData) {
                    for (IngredientData front : ingredientData) {
                        PotDecorations decorations = new PotDecorations(back.item(), left.item(), right.item(), front.item());
                        NSSItem nssDecorated = this.createDecoratedPotItem(decorations);
                        Object2IntMap<NormalizedSimpleStack> nssIngredients = this.getIngredients(back.nss(), left.nss(), right.nss(), front.nss());
                        INSSFakeGroupManager.FakeGroupData group = fakeGroupManager.getOrCreateFakeGroupDirect(nssIngredients, false);
                        mapper.addConversion(1, (NormalizedSimpleStack)nssDecorated, EMCHelper.intMapOf(group.dummy(), 1));
                        ++recipeCount;
                        if (!group.created()) continue;
                        ++uniqueInputs;
                    }
                }
            }
        }
        PECore.debugLog("{} Statistics:", this.getName());
        PECore.debugLog("Found {} Decorated Pot Combinations. With {} unique combinations.", recipeCount, uniqueInputs);
        return true;
    }

    private NSSItem createDecoratedPotItem(PotDecorations decorations) {
        return NSSItem.createItem(DECORATED_POT, DataComponentPatch.builder().set(DataComponents.POT_DECORATIONS, (Object)decorations).build());
    }

    private Object2IntMap<NormalizedSimpleStack> getIngredients(NSSItem nssBack, NSSItem nssLeft, NSSItem nssRight, NSSItem nssFront) {
        Object2IntArrayMap ingredients = new Object2IntArrayMap(4);
        ingredients.put((Object)nssBack, 1);
        ingredients.mergeInt((Object)nssLeft, 1, Constants.INT_SUM);
        ingredients.mergeInt((Object)nssRight, 1, Constants.INT_SUM);
        ingredients.mergeInt((Object)nssFront, 1, Constants.INT_SUM);
        return ingredients;
    }

    @Override
    public String getName() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER_DECORATED_POT.title();
    }

    @Override
    public String getTranslationKey() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER_DECORATED_POT.getTranslationKey();
    }

    @Override
    public String getDescription() {
        return PEConfigTranslations.MAPPING_CRAFTING_MAPPER_DECORATED_POT.tooltip();
    }
}

