/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.EnumSet;
import java.util.Set;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;

@EventBusSubscriber(modid="projecte")
public class TickEvents {
    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        IAlchBagProvider provider = (IAlchBagProvider)player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY);
        if (provider != null) {
            EnumSet<DyeColor> colorsChanged = EnumSet.noneOf(DyeColor.class);
            for (DyeColor color : TickEvents.getBagColorsPresent(player)) {
                IItemHandler inv = provider.getBag(color);
                int slots = inv.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack current = inv.getStackInSlot(i);
                    IAlchBagItem alchBagItem = (IAlchBagItem)current.getCapability(PECapabilities.ALCH_BAG_ITEM_CAPABILITY);
                    if (alchBagItem == null || !alchBagItem.updateInAlchBag(inv, player, current)) continue;
                    colorsChanged.add(color);
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
                if (abstractContainerMenu instanceof AlchBagContainer) {
                    AlchBagContainer container = (AlchBagContainer)abstractContainerMenu;
                    abstractContainerMenu = serverPlayer.getItemInHand(container.hand).getItem();
                    if (abstractContainerMenu instanceof AlchemicalBag) {
                        AlchemicalBag bag = (AlchemicalBag)abstractContainerMenu;
                        colorsChanged.remove(bag.color);
                    }
                }
                provider.sync(serverPlayer, colorsChanged);
            }
        }
        InternalAbilities.tick(player);
        if (!player.level().isClientSide() && player.isOnFire() && TickEvents.shouldPlayerResistFire(player)) {
            player.clearFire();
        }
    }

    public static boolean shouldPlayerResistFire(Player player) {
        for (ItemStack stack2 : player.getArmorSlots()) {
            IFireProtector protector;
            Item item;
            if (stack2.isEmpty() || !((item = stack2.getItem()) instanceof IFireProtector) || !(protector = (IFireProtector)item).canProtectAgainstFire(stack2, player)) continue;
            return true;
        }
        return PlayerHelper.checkHotbarCurios(player, (p, stack) -> {
            IFireProtector protector;
            Item patt0$temp = stack.getItem();
            return patt0$temp instanceof IFireProtector && (protector = (IFireProtector)patt0$temp).canProtectAgainstFire((ItemStack)stack, (Player)p);
        });
    }

    private static Set<DyeColor> getBagColorsPresent(Player player) {
        EnumSet<DyeColor> bagsPresent = EnumSet.noneOf(DyeColor.class);
        IItemHandler inv = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (inv != null) {
            int slots = inv.getSlots();
            for (int i = 0; i < slots; ++i) {
                Item item;
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof AlchemicalBag)) continue;
                AlchemicalBag bag = (AlchemicalBag)item;
                bagsPresent.add(bag.color);
            }
        }
        return bagsPresent;
    }
}

