/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.block_entities.CondenserBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.CondenserMK2Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class CondenserMK2BlockEntity
extends CondenserBlockEntity {
    public CondenserMK2BlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityTypeRegistryObject<? extends CondenserBlockEntity>)PEBlockEntityTypes.CONDENSER_MK2, pos, state);
    }

    @Override
    @NotNull
    protected IItemHandler createAutomationInventory() {
        WrappedItemHandler automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.getInput(), WrappedItemHandler.WriteMode.IN){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserMK2BlockEntity.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        WrappedItemHandler automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.getOutput(), WrappedItemHandler.WriteMode.OUT);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{automationInput, automationOutput});
    }

    @Override
    protected ItemStackHandler createInput() {
        return new EmcBlockEntity.StackHandler(42);
    }

    @Override
    protected ItemStackHandler createOutput() {
        return new EmcBlockEntity.StackHandler(42);
    }

    @Override
    protected void condense() {
        while (this.hasSpace() && this.getStoredEmc() >= this.requiredEmc) {
            this.pushStack();
            this.forceExtractEmc(this.requiredEmc, IEmcStorage.EmcAction.EXECUTE);
        }
        if (this.hasSpace()) {
            int slots = this.getInput().getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = this.getInput().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                this.forceInsertEmc(IEMCProxy.INSTANCE.getSellValue(stack) * (long)stack.getCount(), IEmcStorage.EmcAction.EXECUTE);
                this.getInput().setStackInSlot(i, ItemStack.EMPTY);
                break;
            }
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.getOutput().deserializeNBT(registries, tag.getCompound("output"));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("output", (Tag)this.getOutput().serializeNBT(registries));
    }

    @Override
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInv, @NotNull Player player) {
        return new CondenserMK2Container(windowId, playerInv, this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return TextComponentUtil.build(PEBlocks.CONDENSER_MK2);
    }
}

