/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import moze_intel.projecte.gameObjs.block_entities.RMFurnaceBlockEntity;
import moze_intel.projecte.gameObjs.container.DMFurnaceContainer;
import moze_intel.projecte.gameObjs.container.slots.MatterFurnaceOutputSlot;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.items.IItemHandler;

public class RMFurnaceContainer
extends DMFurnaceContainer {
    public RMFurnaceContainer(int windowId, Inventory playerInv, RMFurnaceBlockEntity furnace) {
        super(PEContainerTypes.RM_FURNACE_CONTAINER, windowId, playerInv, furnace);
    }

    @Override
    void initSlots() {
        int j;
        int i;
        IItemHandler fuel = this.furnace.getFuel();
        IItemHandler input = this.furnace.getInput();
        IItemHandler output = this.furnace.getOutput();
        this.addSlot((Slot)new ValidatedSlot(fuel, 0, 65, 53, SlotPredicates.FURNACE_FUEL));
        this.addSlot((Slot)new ValidatedSlot(input, 0, 65, 17, this.furnace::hasSmeltingResult));
        int counter = 1;
        for (i = 2; i >= 0; --i) {
            for (j = 3; j >= 0; --j) {
                int n = counter++;
                this.addSlot((Slot)new ValidatedSlot(input, n, 11 + i * 18, 8 + j * 18, this.furnace::hasSmeltingResult));
            }
        }
        counter = output.getSlots() - 1;
        this.addSlot((Slot)new MatterFurnaceOutputSlot(this.playerInv.player, this.furnace, output, counter--, 125, 35));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot((Slot)new MatterFurnaceOutputSlot(this.playerInv.player, this.furnace, output, counter--, 147 + i * 18, 8 + j * 18));
            }
        }
        this.addPlayerInventory(24, 84);
    }
}

