/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipesCovalenceRepair
extends CustomRecipe {
    public RecipesCovalenceRepair(CraftingBookCategory category) {
        super(category);
    }

    @Nullable
    private RepairTargetInfo findIngredients(CraftingInput inv) {
        ArrayList<ItemStack> dust = new ArrayList<ItemStack>();
        ItemStack tool = ItemStack.EMPTY;
        for (ItemStack input : inv.items()) {
            if (input.isEmpty()) continue;
            if (input.is(PETags.Items.COVALENCE_DUST)) {
                dust.add(input);
                continue;
            }
            if (tool.isEmpty() && ItemHelper.isRepairableDamagedItem(input)) {
                tool = input;
                continue;
            }
            return null;
        }
        if (tool.isEmpty() || dust.isEmpty()) {
            return null;
        }
        return new RepairTargetInfo(tool, dust.stream().mapToLong(IEMCProxy.INSTANCE::getValue).sum());
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level level) {
        RepairTargetInfo targetInfo = this.findIngredients(inv);
        return targetInfo != null && targetInfo.emcPerDurability <= targetInfo.dustEmc;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registryAccess) {
        RepairTargetInfo targetInfo = this.findIngredients(inv);
        if (targetInfo == null) {
            return ItemStack.EMPTY;
        }
        ItemStack output = targetInfo.tool.copy();
        output.setDamageValue((int)Math.max((long)output.getDamageValue() - targetInfo.dustEmc / targetInfo.emcPerDurability, 0L));
        return output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width > 1 || height > 1;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)PERecipeSerializers.COVALENCE_REPAIR.get();
    }

    private static class RepairTargetInfo {
        private final ItemStack tool;
        private final long emcPerDurability;
        private final long dustEmc;

        public RepairTargetInfo(ItemStack tool, long dustEmc) {
            this.tool = tool;
            this.dustEmc = dustEmc;
            this.emcPerDurability = EMCHelper.getEMCPerDurability(tool);
        }
    }
}

