/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import moze_intel.projecte.gameObjs.entity.NoGravityThrowableProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EntitySWRGProjectile
extends NoGravityThrowableProjectile {
    private boolean fromArcana = false;

    public EntitySWRGProjectile(EntityType<EntitySWRGProjectile> type, Level level) {
        super(type, level);
    }

    public EntitySWRGProjectile(Player player, boolean fromArcana, Level level) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)PEEntityTypes.SWRG_PROJECTILE.get()), (LivingEntity)player, level);
        this.fromArcana = fromArcana;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAlive()) {
            double inverse = 1.0 / (this.isInWater() ? 0.8 : 0.99);
            this.setDeltaMovement(this.getDeltaMovement().scale(inverse));
            if (!this.level().isClientSide && this.isAlive() && this.getY() > (double)this.level().getMaxBuildHeight() && this.level().isRaining()) {
                LevelData levelData = this.level().getLevelData();
                if (levelData instanceof ServerLevelData) {
                    ServerLevelData levelData2 = (ServerLevelData)levelData;
                    levelData2.setThundering(true);
                }
                this.discard();
            }
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        ServerPlayer player;
        ItemStack found;
        Entity entity;
        super.onHitBlock(result);
        if (!this.level().isClientSide && (entity = this.getOwner()) instanceof ServerPlayer && !(found = PlayerHelper.findFirstItem((Player)(player = (ServerPlayer)entity), this.fromArcana ? PEItems.ARCANA_RING : PEItems.SWIFTWOLF_RENDING_GALE)).isEmpty() && ItemPE.consumeFuel((Player)player, found, 768L, true)) {
            BlockPos pos = result.getBlockPos();
            LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            if (lightning != null) {
                lightning.moveTo(pos.getCenter());
                lightning.setCause(player);
                this.level().addFreshEntity((Entity)lightning);
            }
            if (this.level().isThundering()) {
                for (int i = 0; i < 3; ++i) {
                    LightningBolt bonus = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                    if (bonus == null) continue;
                    bonus.moveTo((double)pos.getX() + 0.5 + this.level().random.nextGaussian(), (double)pos.getY() + 0.5 + this.level().random.nextGaussian(), (double)pos.getZ() + 0.5 + this.level().random.nextGaussian());
                    bonus.setCause(player);
                    this.level().addFreshEntity((Entity)bonus);
                }
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (entity = result.getEntity()) instanceof LivingEntity) {
            Player player;
            ItemStack found;
            LivingEntity e = (LivingEntity)entity;
            entity = this.getOwner();
            if (entity instanceof Player && !(found = PlayerHelper.findFirstItem(player = (Player)entity, this.fromArcana ? PEItems.ARCANA_RING : PEItems.SWIFTWOLF_RENDING_GALE)).isEmpty() && ItemPE.consumeFuel(player, found, 64L, true)) {
                e.hurt(this.level().damageSources().playerAttack(player), 1.0f);
                boolean oldOnGround = e.onGround();
                e.setOnGround(true);
                e.knockback(5.0, -this.getDeltaMovement().x() * 0.25, -this.getDeltaMovement().z() * 0.25);
                e.setOnGround(oldOnGround);
                e.setDeltaMovement(e.getDeltaMovement().multiply(1.0, 3.0, 1.0));
            }
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.fromArcana = compound.getBoolean("fromArcana");
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("fromArcana", this.fromArcana);
    }
}

