/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.gui;

import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.block_entities.DMFurnaceBlockEntity;
import moze_intel.projecte.gameObjs.container.DMFurnaceContainer;
import moze_intel.projecte.gameObjs.gui.PEContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GUIDMFurnace<CONTAINER extends DMFurnaceContainer>
extends PEContainerScreen<CONTAINER> {
    private static final ResourceLocation LIT_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/furnace/lit_progress");
    private static final int LIT_SIZE = 14;
    private static final ResourceLocation DM_FURNACE = PECore.rl("textures/gui/dmfurnace.png");
    private final DMFurnaceBlockEntity furnace;
    protected final ResourceLocation texture;

    public GUIDMFurnace(CONTAINER container, Inventory invPlayer, Component title) {
        this(container, invPlayer, title, DM_FURNACE, 178, 165, 57);
    }

    public GUIDMFurnace(CONTAINER container, Inventory invPlayer, Component title, ResourceLocation texture, int textureWidth, int textureHeight, int labelX) {
        super(container, invPlayer, title);
        this.texture = texture;
        this.imageWidth = textureWidth;
        this.imageHeight = textureHeight;
        this.furnace = ((DMFurnaceContainer)((Object)container)).furnace;
        this.titleLabelX = labelX;
        this.inventoryLabelX = labelX;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected int getLitX() {
        return 49;
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        graphics.blit(this.texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.furnace.isLit()) {
            int litProgress = Mth.ceil((float)(this.furnace.getLitProgress() * 11.0f)) + 1;
            int litPortion = 14 - litProgress;
            graphics.blitSprite(LIT_PROGRESS_SPRITE, 14, 14, 0, litPortion, this.leftPos + this.getLitX(), this.topPos + 36 + litPortion, 14, litProgress);
        }
        int burnProgress = Mth.ceil((float)(this.furnace.getBurnProgress() * 24.0f));
        this.renderBurnProgress(graphics, burnProgress);
    }

    protected void renderBurnProgress(@NotNull GuiGraphics graphics, int burnProgress) {
        graphics.blit(this.texture, this.leftPos + 73, this.topPos + 34, 179, 14, burnProgress, 16);
    }
}

