/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.Objects;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class AlchemicalBag
extends ItemPE {
    public final DyeColor color;

    public AlchemicalBag(Item.Properties props, DyeColor color) {
        super(props);
        this.color = color;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            player.openMenu((MenuProvider)new ContainerProvider(player.getItemInHand(hand), hand), buf -> {
                buf.writeEnum((Enum)hand);
                buf.writeByte(player.getInventory().selected);
                buf.writeBoolean(false);
            });
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static ItemStack getFirstBagWithSuctionItem(Player player, NonNullList<ItemStack> inventory) {
        IAlchBagProvider alchBagProvider = null;
        for (ItemStack stack : inventory) {
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof AlchemicalBag)) continue;
            AlchemicalBag bag = (AlchemicalBag)item;
            if (alchBagProvider == null && (alchBagProvider = (IAlchBagProvider)player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)) == null) break;
            IItemHandler inv = alchBagProvider.getBag(bag.color);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack ring = inv.getStackInSlot(i);
                if (ring.isEmpty() || !ring.is(PEItems.BLACK_HOLE_BAND) && !ring.is(PEItems.VOID_RING) || !((Boolean)ring.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) continue;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    private class ContainerProvider
    implements MenuProvider {
        private final ItemStack stack;
        private final InteractionHand hand;

        private ContainerProvider(ItemStack stack, InteractionHand hand) {
            this.stack = stack;
            this.hand = hand;
        }

        @NotNull
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)Objects.requireNonNull((IAlchBagProvider)player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY)).getBag(AlchemicalBag.this.color);
            return new AlchBagContainer(windowId, playerInventory, this.hand, inv, playerInventory.selected, false);
        }

        @NotNull
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }
    }
}

