/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DiviningRod
extends ItemPE
implements IItemMode<DiviningMode> {
    private final int maxModes;

    public DiviningRod(Item.Properties props, int maxModes) {
        super(props.component(PEDataComponentTypes.DIVINING_ROD_MODE, (Object)DiviningMode.LOW));
        this.maxModes = maxModes;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        LongArrayList emcValues = new LongArrayList();
        long totalEmc = 0L;
        int numBlocks = 0;
        int depth = this.getDepthFromMode(ctx.getItemInHand());
        List furnaceRecipes = null;
        for (BlockPos digPos : WorldHelper.getPositionsInBox(WorldHelper.getDeepBox(ctx.getClickedPos(), ctx.getClickedFace(), depth))) {
            List drops;
            BlockState state = level.getBlockState(digPos);
            if (state.isAir() || (drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)digPos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, digPos), (Entity)player, (ItemStack)ctx.getItemInHand())).isEmpty()) continue;
            ItemStack blockStack = (ItemStack)drops.getFirst();
            long blockEmc = IEMCProxy.INSTANCE.getValue(blockStack);
            if (blockEmc == 0L) {
                if (furnaceRecipes == null) {
                    furnaceRecipes = level.getRecipeManager().getAllRecipesFor(RecipeType.SMELTING);
                }
                for (RecipeHolder furnaceRecipeHolder : furnaceRecipes) {
                    long currentValue;
                    SmeltingRecipe furnaceRecipe = (SmeltingRecipe)furnaceRecipeHolder.value();
                    if (!((Ingredient)furnaceRecipe.getIngredients().getFirst()).test(blockStack) || (currentValue = IEMCProxy.INSTANCE.getValue(furnaceRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()))) == 0L) continue;
                    if (!emcValues.contains(currentValue)) {
                        emcValues.add(currentValue);
                    }
                    totalEmc += currentValue;
                    break;
                }
            } else {
                if (!emcValues.contains(blockEmc)) {
                    emcValues.add(blockEmc);
                }
                totalEmc += blockEmc;
            }
            ++numBlocks;
        }
        if (numBlocks == 0) {
            return InteractionResult.FAIL;
        }
        player.sendSystemMessage((Component)PELang.DIVINING_AVG_EMC.translate(numBlocks, totalEmc / (long)numBlocks));
        if (this == PEItems.MEDIUM_DIVINING_ROD.get() || this == PEItems.HIGH_DIVINING_ROD.get()) {
            emcValues.sort(LongComparators.OPPOSITE_COMPARATOR);
            player.sendSystemMessage((Component)PELang.DIVINING_SECOND_MAX.translate(DiviningRod.getOrDefault((LongList)emcValues, 0)));
            if (this == PEItems.HIGH_DIVINING_ROD.get()) {
                player.sendSystemMessage((Component)PELang.DIVINING_SECOND_MAX.translate(DiviningRod.getOrDefault((LongList)emcValues, 1)));
                player.sendSystemMessage((Component)PELang.DIVINING_THIRD_MAX.translate(DiviningRod.getOrDefault((LongList)emcValues, 2)));
            }
        }
        return InteractionResult.CONSUME;
    }

    private static long getOrDefault(LongList emcValues, int index) {
        return index < emcValues.size() ? emcValues.getLong(index) : 1L;
    }

    private int getDepthFromMode(ItemStack stack) {
        DiviningMode mode = (DiviningMode)IItemMode.super.getMode(stack);
        if (mode.ordinal() > this.maxModes) {
            return 0;
        }
        return mode.range;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add(this.getToolTip(stack));
    }

    @Override
    public DataComponentType<DiviningMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.DIVINING_ROD_MODE.get();
    }

    @Override
    public DiviningMode getDefaultMode() {
        return DiviningMode.LOW;
    }

    public static enum DiviningMode implements IModeEnum<DiviningMode>
    {
        LOW(PELang.DIVINING_RANGE_3, 3),
        MEDIUM(PELang.DIVINING_RANGE_16, 16),
        HIGH(PELang.DIVINING_RANGE_64, 64);

        public static final Codec<DiviningMode> CODEC;
        public static final IntFunction<DiviningMode> BY_ID;
        public static final StreamCodec<ByteBuf, DiviningMode> STREAM_CODEC;
        private final IHasTranslationKey langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final int range;

        private DiviningMode(IHasTranslationKey langEntry, int range) {
            this.langEntry = langEntry;
            this.range = range;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public DiviningMode next(ItemStack stack) {
            if (this.ordinal() > ((DiviningRod)stack.getItem()).maxModes) {
                return this;
            }
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> MEDIUM;
                case 1 -> HIGH;
                case 2 -> LOW;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(DiviningMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DiviningMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

