/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class EvertideAmulet
extends ItemPE
implements IProjectileShooter,
IPedestalItem,
ICapabilityAware {
    public EvertideAmulet(Item.Properties props) {
        super(props);
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.copy();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (!level.isClientSide && PlayerHelper.hasEditPermission(player, level, pos)) {
            Direction sideHit = ctx.getClickedFace();
            IFluidHandler fluidHandler = (IFluidHandler)WorldHelper.getCapability(level, Capabilities.FluidHandler.BLOCK, pos, sideHit);
            if (fluidHandler != null) {
                fluidHandler.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                return InteractionResult.CONSUME;
            }
            WorldHelper.placeFluid(player, level, pos, sideHit, Fluids.WATER, !ProjectEConfig.server.items.opEvertide.get());
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.WATER_MAGIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        Level level = player.level();
        if (ProjectEConfig.server.items.opEvertide.get() || !level.dimensionType().ultraWarm()) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.WATER_MAGIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            EntityWaterProjectile ent = new EntityWaterProjectile(player, level);
            ent.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)ent);
            return true;
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)PELang.TOOLTIP_EVERTIDE_1.translate(ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        tooltip.add((Component)PELang.TOOLTIP_EVERTIDE_2.translate());
        tooltip.add((Component)PELang.TOOLTIP_EVERTIDE_3.translate());
        tooltip.add((Component)PELang.TOOLTIP_EVERTIDE_4.translate());
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.evertide.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                LevelData levelData = level.getLevelData();
                if (levelData instanceof ServerLevelData) {
                    ServerLevelData worldInfo = (ServerLevelData)levelData;
                    int i = (300 + level.random.nextInt(600)) * 20;
                    worldInfo.setRainTime(i);
                    worldInfo.setThunderTime(i);
                    worldInfo.setRaining(true);
                }
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.evertide.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.evertide.get() != -1) {
            list.add((Component)PELang.PEDESTAL_EVERTIDE_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_EVERTIDE_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.evertide.get(), tickRate)));
        }
        return list;
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new InfiniteFluidHandler((ItemStack)stack), new ItemLike[]{this});
        IntegrationHelper.registerCuriosCapability(event, this);
    }

    private record InfiniteFluidHandler(ItemStack stack) implements IFluidHandlerItem
    {
        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? new FluidStack((Fluid)Fluids.WATER, Integer.MAX_VALUE) : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? Integer.MAX_VALUE : 0;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.isWater(stack);
        }

        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            return this.isWater(resource) ? resource.getAmount() : 0;
        }

        @NotNull
        public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            return this.isWater(resource) ? resource : FluidStack.EMPTY;
        }

        private boolean isWater(FluidStack stack) {
            return stack.is(FluidTags.WATER);
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.WATER, maxDrain);
        }
    }
}

