/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.integration.IntegrationHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class KleinStar
extends ItemPE
implements IItemEmcHolder,
IBarHelper,
ICapabilityAware {
    public final KleinTier tier;

    public KleinStar(Item.Properties props, KleinTier tier) {
        super(props.component(PEDataComponentTypes.STORED_EMC, (Object)0L));
        this.tier = tier;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return this.getStoredEmc(stack) > 0L;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        long starEmc = this.getStoredEmc(stack);
        if (starEmc == 0L) {
            return 1.0f;
        }
        return (float)(1.0 - (double)starEmc / (double)this.tier.maxEmc);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && !FMLEnvironment.production && player.isCreative()) {
            stack.set(PEDataComponentTypes.STORED_EMC, (Object)this.getMaximumEmc(stack));
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public long insertEmc(@NotNull ItemStack stack, long toInsert, IEmcStorage.EmcAction action) {
        if (toInsert < 0L) {
            return this.extractEmc(stack, -toInsert, action);
        }
        long maxEmc = this.getMaximumEmc(stack);
        long storedEmc = this.getStoredEmc(stack);
        if (storedEmc >= maxEmc) {
            return 0L;
        }
        long toAdd = Math.min(maxEmc - storedEmc, toInsert);
        if (action.execute()) {
            stack.set(PEDataComponentTypes.STORED_EMC, (Object)(storedEmc + toAdd));
        }
        return toAdd;
    }

    @Override
    public long extractEmc(@NotNull ItemStack stack, long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(stack, -toExtract, action);
        }
        long storedEmc = this.getStoredEmc(stack);
        long toRemove = Math.min(storedEmc, toExtract);
        if (action.execute()) {
            stack.set(PEDataComponentTypes.STORED_EMC, (Object)(storedEmc - toRemove));
        }
        return toRemove;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getStoredEmc(@NotNull ItemStack stack) {
        return (Long)stack.getOrDefault(PEDataComponentTypes.STORED_EMC, (Object)0L);
    }

    @Override
    public @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long getMaximumEmc(@NotNull ItemStack stack) {
        return this.tier.maxEmc;
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }

    public static enum KleinTier {
        EIN("ein", 50000L),
        ZWEI("zwei", 200000L),
        DREI("drei", 800000L),
        VIER("vier", 3200000L),
        SPHERE("sphere", 12800000L),
        OMEGA("omega", 51200000L);

        public final String name;
        public final long maxEmc;

        private KleinTier(String name, long maxEmc) {
            this.name = name;
            this.maxEmc = maxEmc;
        }
    }
}

