/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.container.MercurialEyeContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MercurialEye
extends ItemMode<MercurialEyeMode>
implements IExtraFunction,
ICapabilityAware {
    public MercurialEye(Item.Properties props) {
        super(props.component(PEDataComponentTypes.MERCURIAL_EYE_MODE, (Object)MercurialEyeMode.CREATION).component(PEDataComponentTypes.EYE_INVENTORY, (Object)ItemContainerContents.EMPTY), 4);
    }

    @Override
    public boolean doExtraFunction(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        int selected = player.getInventory().selected;
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, pl) -> new MercurialEyeContainer(id, inv, hand, selected), stack.getHoverName());
        player.openMenu((MenuProvider)provider, b -> {
            b.writeEnum((Enum)hand);
            b.writeByte(selected);
        });
        return true;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        Level level = ctx.getLevel();
        return level.isClientSide ? InteractionResult.SUCCESS : this.formBlocks(stack, ctx.getPlayer(), ctx.getHand(), level, ctx.getClickedPos(), ctx.getClickedFace());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.getMode(stack) == MercurialEyeMode.CREATION) {
            if (level.isClientSide) {
                return InteractionResultHolder.success((Object)stack);
            }
            Vec3 targVec = PlayerHelper.getLookTarget(player, 2.0);
            return ItemHelper.actionResultFromType(this.formBlocks(stack, player, hand, level, BlockPos.containing((Position)targVec), null), stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private void playNoEMCSound(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private InteractionResult formBlocks(ItemStack eye, Player player, InteractionHand hand, Level level, BlockPos startingPos, @Nullable Direction facing) {
        long newBlockEmc;
        BlockState newState;
        BlockPlaceContext context;
        IItemHandler inventory = (IItemHandler)eye.getCapability(Capabilities.ItemHandler.ITEM);
        if (inventory == null) {
            return InteractionResult.FAIL;
        }
        ItemStack klein = inventory.getStackInSlot(0);
        if (klein.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY) == null) {
            this.playNoEMCSound(player);
            return InteractionResult.FAIL;
        }
        BlockState startingState = level.getBlockState(startingPos);
        long startingBlockEmc = IEMCProxy.INSTANCE.getValue((ItemLike)startingState.getBlock());
        ItemStack target = inventory.getStackInSlot(1);
        MercurialEyeMode mode = (MercurialEyeMode)this.getMode(eye);
        BlockHitResult hitResult = facing == null ? new BlockHitResult(startingPos.getCenter(), Direction.UP, startingPos, true) : new BlockHitResult(startingPos.relative(facing).getCenter(), facing, startingPos, false);
        if (!target.isEmpty()) {
            context = new BlockPlaceContext(level, player, hand, target.copy(), hitResult);
            newState = ItemHelper.stackToState(target, context);
            newBlockEmc = IEMCProxy.INSTANCE.getValue(target);
            if (newBlockEmc == 0L) {
                return InteractionResult.FAIL;
            }
        } else if (startingBlockEmc != 0L && mode.isExtension()) {
            newState = startingState;
            newBlockEmc = startingBlockEmc;
            context = new BlockPlaceContext(level, player, hand, new ItemStack((ItemLike)newState.getBlock()), hitResult);
        } else {
            return InteractionResult.FAIL;
        }
        if (newState == null || newState.isAir()) {
            return InteractionResult.FAIL;
        }
        NonNullList drops = NonNullList.create();
        int charge = this.getCharge(eye);
        int hitTargets = 0;
        if (mode == MercurialEyeMode.CREATION) {
            if (facing != null && (!context.replacingClickedOnBlock() || context.isSecondaryUseActive() && !startingState.isAir())) {
                BlockPos offsetPos = startingPos.relative(facing);
                BlockState offsetState = level.getBlockState(offsetPos);
                if (!offsetState.canBeReplaced(context)) {
                    return InteractionResult.FAIL;
                }
                long offsetBlockEmc = IEMCProxy.INSTANCE.getValue((ItemLike)offsetState.getBlock());
                if (this.doBlockPlace(player, level, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops, context)) {
                    ++hitTargets;
                }
            } else if (this.doBlockPlace(player, level, startingState, startingPos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops, context)) {
                ++hitTargets;
            }
        } else if (mode == MercurialEyeMode.PILLAR) {
            AABB bounds = this.getBounds(startingPos, facing, 1, 3 * charge + 2);
            hitTargets += this.fillGaps(eye, player, level, context, startingState, newState, newBlockEmc, bounds, (NonNullList<ItemStack>)drops);
        } else if (mode == MercurialEyeMode.EXTENSION_CLASSIC) {
            AABB bounds = this.getBounds(startingPos, facing, charge, 0);
            hitTargets += this.fillGaps(eye, player, level, context, startingState, newState, newBlockEmc, bounds, (NonNullList<ItemStack>)drops);
        } else if (mode == MercurialEyeMode.TRANSMUTATION_CLASSIC) {
            AABB bounds = this.getBounds(startingPos, facing, charge, 0);
            for (BlockPos pos : WorldHelper.getPositionsInBox(bounds)) {
                BlockState placedState = level.getBlockState(pos);
                if (placedState != startingState || !this.doBlockPlace(player, level, placedState, pos.immutable(), newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops, context)) continue;
                ++hitTargets;
            }
        } else {
            if (startingState.isAir() || facing == null) {
                return InteractionResult.FAIL;
            }
            LinkedList<BlockPos> possibleBlocks = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            possibleBlocks.add(startingPos);
            visited.add(startingPos);
            int side = 2 * charge + 1;
            int size = side * side;
            int totalTries = size * 4;
            for (int attemptedTargets = 0; attemptedTargets < totalTries && !possibleBlocks.isEmpty(); ++attemptedTargets) {
                BlockPos offsetPos;
                BlockState offsetState;
                BlockPos pos = (BlockPos)possibleBlocks.poll();
                BlockState checkState = level.getBlockState(pos);
                if (startingState != checkState || (offsetState = level.getBlockState(offsetPos = pos.relative(facing))).isFaceSturdy((BlockGetter)level, offsetPos, facing)) continue;
                boolean hit = false;
                if (mode == MercurialEyeMode.EXTENSION) {
                    VoxelShape cbBox = startingState.getCollisionShape((BlockGetter)level, offsetPos);
                    if (level.isUnobstructed(null, cbBox)) {
                        long offsetBlockEmc = IEMCProxy.INSTANCE.getValue((ItemLike)offsetState.getBlock());
                        hit = this.doBlockPlace(player, level, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops, context);
                    }
                } else if (mode == MercurialEyeMode.TRANSMUTATION) {
                    hit = this.doBlockPlace(player, level, checkState, pos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops, context);
                }
                if (!hit) continue;
                if (++hitTargets < size) {
                    for (Direction e : Constants.DIRECTIONS) {
                        BlockPos offsetOpposite;
                        if (facing.getAxis() == e.getAxis()) continue;
                        BlockPos offset = pos.relative(e);
                        if (visited.add(offset)) {
                            possibleBlocks.offer(offset);
                        }
                        if (!visited.add(offsetOpposite = pos.relative(e.getOpposite()))) continue;
                        possibleBlocks.offer(offsetOpposite);
                    }
                    continue;
                }
                break;
            }
        }
        if (hitTargets > 0) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 0.8f, 2.0f / ((float)charge / (float)this.getNumCharges(eye) + 2.0f));
            WorldHelper.createLootDrop((List<ItemStack>)drops, player.level(), startingPos);
        }
        return InteractionResult.CONSUME;
    }

    private boolean doBlockPlace(Player player, Level level, BlockState oldState, BlockPos placePos, BlockState newState, ItemStack eye, long oldEMC, long newEMC, NonNullList<ItemStack> drops, BlockPlaceContext context) {
        if (oldState.hasBlockEntity()) {
            return false;
        }
        if (!newState.getValues().isEmpty()) {
            BlockPlaceContext adjustedContext = BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)placePos, (Direction)context.getClickedFace());
            adjustedContext.replaceClicked = true;
            if ((newState = newState.getBlock().getStateForPlacement(adjustedContext)) == null) {
                return false;
            }
        }
        return this.doBlockPlace(player, level, oldState, placePos, newState, eye, oldEMC, newEMC, drops);
    }

    private boolean doBlockPlace(Player player, Level level, BlockState oldState, BlockPos placePos, BlockState newState, ItemStack eye, long oldEMC, long newEMC, NonNullList<ItemStack> drops) {
        if (oldState == newState || oldState.hasBlockEntity()) {
            return false;
        }
        IItemHandler inventory = (IItemHandler)eye.getCapability(Capabilities.ItemHandler.ITEM);
        if (inventory == null) {
            return false;
        }
        ItemStack klein = inventory.getStackInSlot(0);
        IItemEmcHolder emcHolder = (IItemEmcHolder)klein.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY);
        if (emcHolder == null || emcHolder.getStoredEmc(klein) < newEMC - oldEMC) {
            this.playNoEMCSound(player);
            return false;
        }
        if (oldEMC == 0L && oldState.getDestroySpeed((BlockGetter)level, placePos) == -1.0f) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (PlayerHelper.checkedReplaceBlock(serverPlayer, level, placePos, newState)) {
            ItemStack replacement = klein.copy();
            if (oldEMC > newEMC) {
                emcHolder.insertEmc(replacement, oldEMC - newEMC, IEmcStorage.EmcAction.EXECUTE);
            } else if (oldEMC != newEMC) {
                if (oldEMC == 0L) {
                    drops.addAll((Collection)Block.getDrops((BlockState)oldState, (ServerLevel)serverPlayer.serverLevel(), (BlockPos)placePos, null, (Entity)player, (ItemStack)eye));
                }
                emcHolder.extractEmc(replacement, newEMC - oldEMC, IEmcStorage.EmcAction.EXECUTE);
            }
            if (inventory instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)inventory;
                modifiable.setStackInSlot(0, replacement);
            }
            return true;
        }
        return false;
    }

    private int fillGaps(ItemStack eye, Player player, Level level, BlockPlaceContext context, BlockState startingState, BlockState newState, long newBlockEmc, AABB bounds, NonNullList<ItemStack> drops) {
        int hitTargets = 0;
        for (BlockPos pos : WorldHelper.getPositionsInBox(bounds)) {
            BlockState forPlacement;
            BlockPlaceContext adjustedContext;
            VoxelShape bb = startingState.getCollisionShape((BlockGetter)level, pos);
            if (!level.isUnobstructed(null, bb) || !(adjustedContext = BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)pos, (Direction)context.getClickedFace())).replacingClickedOnBlock()) continue;
            BlockState placeState = level.getBlockState(pos);
            long placeBlockEmc = IEMCProxy.INSTANCE.getValue((ItemLike)placeState.getBlock());
            if (!newState.getValues().isEmpty() && (forPlacement = newState.getBlock().getStateForPlacement(adjustedContext)) == null || !this.doBlockPlace(player, level, placeState, pos.immutable(), newState, eye, placeBlockEmc, newBlockEmc, drops)) continue;
            ++hitTargets;
        }
        return hitTargets;
    }

    private AABB getBounds(BlockPos startingPos, @Nullable Direction facing, int strength, int depth) {
        if (facing == null) {
            return new AABB(startingPos);
        }
        return WorldHelper.getBroadDeepBox(startingPos, facing, strength, depth);
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> new EyeItemHandler((MutableDataComponentHolder)stack), new ItemLike[]{this});
    }

    @Override
    public DataComponentType<MercurialEyeMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.MERCURIAL_EYE_MODE.get();
    }

    @Override
    public MercurialEyeMode getDefaultMode() {
        return MercurialEyeMode.CREATION;
    }

    public static enum MercurialEyeMode implements IModeEnum<MercurialEyeMode>
    {
        CREATION(PELang.MODE_MERCURIAL_EYE_1),
        EXTENSION(PELang.MODE_MERCURIAL_EYE_2),
        EXTENSION_CLASSIC(PELang.MODE_MERCURIAL_EYE_3),
        TRANSMUTATION(PELang.MODE_MERCURIAL_EYE_4),
        TRANSMUTATION_CLASSIC(PELang.MODE_MERCURIAL_EYE_5),
        PILLAR(PELang.MODE_MERCURIAL_EYE_6);

        public static final Codec<MercurialEyeMode> CODEC;
        public static final IntFunction<MercurialEyeMode> BY_ID;
        public static final StreamCodec<ByteBuf, MercurialEyeMode> STREAM_CODEC;
        private final IHasTranslationKey langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        private MercurialEyeMode(IHasTranslationKey langEntry) {
            this.langEntry = langEntry;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        public boolean isExtension() {
            return this == EXTENSION || this == EXTENSION_CLASSIC;
        }

        @Override
        public MercurialEyeMode next(ItemStack stack) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EXTENSION;
                case 1 -> EXTENSION_CLASSIC;
                case 2 -> TRANSMUTATION;
                case 3 -> TRANSMUTATION_CLASSIC;
                case 4 -> PILLAR;
                case 5 -> CREATION;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(MercurialEyeMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MercurialEyeMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private static class EyeItemHandler
    extends ComponentItemHandler {
        public EyeItemHandler(MutableDataComponentHolder parent) {
            super(parent, (DataComponentType)PEDataComponentTypes.EYE_INVENTORY.get(), 2);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.isEmpty()) {
                return true;
            }
            if (slot == 0) {
                return SlotPredicates.EMC_HOLDER.test(stack);
            }
            return SlotPredicates.MERCURIAL_TARGET.test(stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void updateContents(@NotNull ItemContainerContents contents, @NotNull ItemStack stack, int slot) {
            super.updateContents(contents, stack.copyWithCount(1), slot);
        }
    }
}

