/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutationFunction;
import moze_intel.projecte.gameObjs.container.PhilosStoneContainer;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.IModeEnum;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.world_transmutation.WorldTransmutationManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class PhilosophersStone
extends ItemMode<PhilosophersStoneMode>
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone(Item.Properties props) {
        super(props.component(PEDataComponentTypes.PHILOSOPHERS_STONE_MODE, (Object)PhilosophersStoneMode.CUBE), 4);
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.copy();
    }

    public BlockHitResult getHitBlock(Level level, Player player, boolean isSneaking) {
        return PhilosophersStone.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(isSneaking ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext ctx) {
        BlockHitResult rtr;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockPos pos = ctx.getClickedPos();
        Direction sideHit = ctx.getClickedFace();
        boolean isSneaking = ctx.isSecondaryUseActive();
        if (isSneaking && player != null && (rtr = this.getHitBlock(level, player, true)).getType() == HitResult.Type.BLOCK && !rtr.getBlockPos().equals((Object)pos)) {
            pos = rtr.getBlockPos();
            sideHit = rtr.getDirection();
        }
        if (level.isClientSide) {
            if (WorldTransmutationManager.INSTANCE.getWorldTransmutation(level.getBlockState(pos), true) == null) {
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        Object2ReferenceMap<BlockPos, BlockState> toChange = PhilosophersStone.getChanges(level, pos, sideHit, ctx.getHorizontalDirection(), isSneaking, (PhilosophersStoneMode)this.getMode(stack), this.getCharge(stack));
        if (toChange.isEmpty()) {
            return InteractionResult.PASS;
        }
        ObjectIterator iterator = Object2ReferenceMaps.fastIterator(toChange);
        while (iterator.hasNext()) {
            Object2ReferenceMap.Entry entry = (Object2ReferenceMap.Entry)iterator.next();
            BlockPos currentPos = (BlockPos)entry.getKey();
            BlockState targetState = (BlockState)entry.getValue();
            if (player == null) {
                BlockEntity blockEntity;
                if (targetState.getBlock() instanceof SignBlock && (blockEntity = level.getBlockEntity(currentPos)) instanceof SignBlockEntity) {
                    SignBlockEntity sign = (SignBlockEntity)blockEntity;
                    level.setBlockAndUpdate(currentPos, targetState);
                    WorldHelper.copySignData(level, currentPos, sign);
                } else {
                    level.setBlockAndUpdate(currentPos, targetState);
                }
            } else {
                PlayerHelper.checkedReplaceBlock((ServerPlayer)player, level, currentPos, targetState);
            }
            if (level.random.nextInt(8) != 0) continue;
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)currentPos.getX(), (double)(currentPos.getY() + 1), (double)currentPos.getZ(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        BlockPos soundPos = player == null ? pos : player.blockPosition();
        level.playSound(null, (double)soundPos.getX(), (double)soundPos.getY(), (double)soundPos.getZ(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        Level level = player.level();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        EntityMobRandomizer ent = new EntityMobRandomizer(player, level);
        ent.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
        level.addFreshEntity((Entity)ent);
        return true;
    }

    @Override
    public boolean doExtraFunction(@NotNull Player player, @NotNull ItemStack stack, InteractionHand hand) {
        if (!player.level().isClientSide) {
            player.openMenu((MenuProvider)new ContainerProvider(stack));
        }
        return true;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        tooltip.add((Component)PELang.TOOLTIP_PHILOSTONE.translate(ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)));
    }

    public static Object2ReferenceMap<BlockPos, BlockState> getChanges(Level level, BlockPos pos, Direction sideHit, Direction horizontalDirection, boolean isSneaking, PhilosophersStoneMode mode, int charge) {
        Iterable<BlockPos> targets;
        IWorldTransmutationFunction transmutation = WorldTransmutationManager.INSTANCE.getWorldTransmutation(level.getBlockState(pos));
        if (transmutation == null) {
            return Object2ReferenceMaps.emptyMap();
        }
        block0 : switch (mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Iterable<BlockPos> iterable = WorldHelper.positionsAround(pos, charge);
                break;
            }
            case 1: {
                Iterable<BlockPos> iterable;
                switch (sideHit.getAxis()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        iterable = WorldHelper.positionsAround(pos, 0, charge, charge);
                        break block0;
                    }
                    case Y: {
                        iterable = WorldHelper.horizontalPositionsAround(pos, charge);
                        break block0;
                    }
                    case Z: 
                }
                iterable = WorldHelper.positionsAround(pos, charge, charge, 0);
                break;
            }
            case 2: {
                Iterable<BlockPos> iterable;
                switch (horizontalDirection.getAxis()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        iterable = WorldHelper.positionsAround(pos, charge, 0, 0);
                        break block0;
                    }
                    case Y: {
                        iterable = null;
                        break block0;
                    }
                    case Z: 
                }
                iterable = targets = WorldHelper.positionsAround(pos, 0, 0, charge);
            }
        }
        if (targets == null) {
            return Object2ReferenceMaps.emptyMap();
        }
        Object2ReferenceOpenHashMap changes = new Object2ReferenceOpenHashMap();
        for (BlockPos currentPos : targets) {
            BlockState actualResult;
            if (!WorldHelper.isBlockLoaded((BlockGetter)level, currentPos) || (actualResult = transmutation.result(level.getBlockState(currentPos), isSneaking)) == null) continue;
            changes.put((Object)currentPos.immutable(), (Object)actualResult);
        }
        return changes;
    }

    @Override
    public DataComponentType<PhilosophersStoneMode> getDataComponentType() {
        return (DataComponentType)PEDataComponentTypes.PHILOSOPHERS_STONE_MODE.get();
    }

    @Override
    public PhilosophersStoneMode getDefaultMode() {
        return PhilosophersStoneMode.CUBE;
    }

    public static enum PhilosophersStoneMode implements IModeEnum<PhilosophersStoneMode>
    {
        CUBE(PELang.MODE_PHILOSOPHER_1),
        PANEL(PELang.MODE_PHILOSOPHER_2),
        LINE(PELang.MODE_PHILOSOPHER_3);

        public static final Codec<PhilosophersStoneMode> CODEC;
        public static final IntFunction<PhilosophersStoneMode> BY_ID;
        public static final StreamCodec<ByteBuf, PhilosophersStoneMode> STREAM_CODEC;
        private final IHasTranslationKey langEntry;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        private PhilosophersStoneMode(IHasTranslationKey langEntry) {
            this.langEntry = langEntry;
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        public PhilosophersStoneMode next(ItemStack stack) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PANEL;
                case 1 -> LINE;
                case 2 -> CUBE;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(PhilosophersStoneMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])PhilosophersStoneMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    private record ContainerProvider(ItemStack stack) implements MenuProvider
    {
        @NotNull
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            return new PhilosStoneContainer(windowId, playerInventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)player.blockPosition()));
        }

        @NotNull
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }
    }
}

