/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

public class ArchangelSmite
extends PEToggleItem
implements IPedestalItem {
    public ArchangelSmite(Item.Properties props) {
        super(props.component(PEDataComponentTypes.STORED_EMC, (Object)0L));
        NeoForge.EVENT_BUS.addListener(this::emptyLeftClick);
        NeoForge.EVENT_BUS.addListener(this::leftClickBlock);
    }

    public static void fireVolley(ItemStack stack, Player player) {
        for (int i = 0; i < 10; ++i) {
            ArchangelSmite.fireArrow(stack, player.level(), (LivingEntity)player, 4.0f);
        }
    }

    private void emptyLeftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        PECore.packetHandler().activateArchangel();
    }

    private void leftClickBlock(PlayerInteractEvent.LeftClickBlock evt) {
        if (!evt.getLevel().isClientSide && evt.getUseItem() != TriState.FALSE && !evt.getItemStack().isEmpty() && evt.getItemStack().is((Item)this)) {
            ArchangelSmite.fireVolley(evt.getItemStack(), evt.getEntity());
        }
    }

    public boolean onLeftClickEntity(@NotNull ItemStack stack, Player player, @NotNull Entity entity) {
        if (!player.level().isClientSide) {
            ArchangelSmite.fireVolley(stack, player);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (!level.isClientSide && this.getMode(stack).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ArchangelSmite.fireArrow(stack, level, living, 1.0f);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            ArchangelSmite.fireArrow(player.getItemInHand(hand), level, (LivingEntity)player, 1.0f);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private static void fireArrow(ItemStack ring, Level level, LivingEntity shooter, float inaccuracy) {
        Player player;
        EntityHomingArrow arrow = new EntityHomingArrow(level, shooter, 2.0f);
        if (!(shooter instanceof Player) || ArchangelSmite.consumeFuel(player = (Player)shooter, ring, IEMCProxy.INSTANCE.getValue((ItemLike)Items.ARROW), true)) {
            arrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 3.0f, inaccuracy);
            level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f));
            level.addFreshEntity((Entity)arrow);
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.isClientSide && ProjectEConfig.server.cooldown.pedestal.archangel.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                if (!level.getEntitiesOfClass(Mob.class, ((IDMPedestal)pedestal).getEffectBounds()).isEmpty()) {
                    double centeredX = (double)pos.getX() + 0.5;
                    double centeredY = (double)pos.getY() + 0.5;
                    double centeredZ = (double)pos.getZ() + 0.5;
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(level, (LivingEntity)FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)PECore.FAKEPLAYER_GAMEPROFILE), 2.0f);
                        arrow.setPosRaw(centeredX, centeredY + 2.0, centeredZ);
                        arrow.setDeltaMovement(0.0, 1.0, 0.0);
                        arrow.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + 0.5f);
                        level.addFreshEntity((Entity)arrow);
                    }
                }
                ((IDMPedestal)pedestal).setActivityCooldown(level, pos, ProjectEConfig.server.cooldown.pedestal.archangel.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown(level, pos);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.archangel.get() != -1) {
            list.add((Component)PELang.PEDESTAL_ARCHANGEL_1.translateColored(ChatFormatting.BLUE));
            list.add((Component)PELang.PEDESTAL_ARCHANGEL_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.archangel.get(), tickRate)));
        }
        return list;
    }
}

