/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.gameObjs.items.ICapabilityAware;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class BlackHoleBand
extends PEToggleItem
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem,
ICapabilityAware {
    public BlackHoleBand(Item.Properties props) {
        super(props);
    }

    private InteractionResult tryPickupFluid(Level level, Player player, ItemStack stack) {
        Block block;
        BlockHitResult result = BlackHoleBand.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (result.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos fluidPos = result.getBlockPos();
        BlockState state = level.getBlockState(fluidPos);
        if (level.mayInteract(player, fluidPos) && player.mayUseItemAt(fluidPos, result.getDirection(), stack) && (block = state.getBlock()) instanceof BucketPickup) {
            BucketPickup pickup = (BucketPickup)block;
            Optional sound = pickup.getPickupSound(state);
            ItemStack itemStack = pickup.pickupBlock(player, (LevelAccessor)level, fluidPos, state);
            if (!itemStack.isEmpty()) {
                if (sound.isPresent()) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)sound.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResult result = this.tryPickupFluid(level, player, stack);
        if (!result.consumesAction() && this.changeMode(player, stack, hand)) {
            result = InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemHelper.actionResultFromType(result, stack);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isHeld) {
        super.inventoryTick(stack, level, entity, slot, isHeld);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
                for (ItemEntity item : level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(7.0))) {
                    if (ItemHelper.simulateFit((NonNullList<ItemStack>)player.getInventory().items, item.getItem()) >= item.getItem().getCount()) continue;
                    WorldHelper.gravitateEntityTowards((Entity)item, player.position());
                }
            }
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        Vec3 target = pos.getCenter();
        EnumMap<Direction, IItemHandler> nearbyHandlers = new EnumMap<Direction, IItemHandler>(Direction.class);
        block0: for (ItemEntity item : level.getEntitiesOfClass(ItemEntity.class, ((IDMPedestal)pedestal).getEffectBounds(), ent -> !ent.isSpectator() && ent.isAlive())) {
            WorldHelper.gravitateEntityTowards((Entity)item, target);
            if (level.isClientSide || !(item.distanceToSqr(target) < 1.21)) continue;
            for (Direction dir : Constants.DIRECTIONS) {
                ItemStack result;
                IItemHandler inv = (IItemHandler)nearbyHandlers.get(dir);
                if (inv == null) {
                    inv = (IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos.relative(dir), dir);
                    nearbyHandlers.put(dir, inv);
                }
                if ((result = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)item.getItem(), (boolean)false)).isEmpty()) {
                    item.discard();
                    continue block0;
                }
                item.setItem(result);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription(float tickRate) {
        return List.of(PELang.PEDESTAL_BLACK_HOLE_BAND_1.translateColored(ChatFormatting.BLUE), PELang.PEDESTAL_BLACK_HOLE_BAND_2.translateColored(ChatFormatting.BLUE));
    }

    @Override
    public boolean updateInAlchChest(@NotNull Level level, @NotNull BlockPos pos, @NotNull ItemStack stack) {
        IItemHandler handler;
        if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue() && (handler = (IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos, null)) != null) {
            AABB aabb = new AABB(pos).inflate(5.0);
            Vec3 center = aabb.getCenter();
            for (ItemEntity e : level.getEntitiesOfClass(ItemEntity.class, aabb, ent -> !ent.isSpectator() && ent.isAlive())) {
                WorldHelper.gravitateEntityTowards((Entity)e, center);
                if (level.isClientSide || !(e.distanceToSqr(center) < 1.21)) continue;
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)e.getItem(), (boolean)false);
                if (!result.isEmpty()) {
                    e.setItem(result);
                    continue;
                }
                e.discard();
            }
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@NotNull IItemHandler inv, @NotNull Player player, @NotNull ItemStack stack) {
        if (((Boolean)stack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)).booleanValue()) {
            for (ItemEntity e : player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.position());
            }
        }
        return false;
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        IntegrationHelper.registerCuriosCapability(event, this);
    }
}

